--------------- Script Activation ---------------------

--		N O T E S

--		* if .states isn't defined, states is assumed to be {"START"}
--		* if .states is defined, one of the states /must/ be "START"
--		* if AbleToRun isn't defined, quest is assumed to always be runnable
--		  when in a valid chapter
--		* (possibly could do the same with start_chap and end_chap, assuming
--		  quest runs from Chapters.Start to Chapters.End if not defined)


ScriptActivation = {}

-- // --  C O R E  -- // --

-- ** --  QU000 - The Road To Rule -- ** --

ScriptActivation[ScriptCode.QU000] = {}
ScriptActivation[ScriptCode.QU000].name = "QU000_RoadToRule"
ScriptActivation[ScriptCode.QU000].display_name = "The Road To Rule"
ScriptActivation[ScriptCode.QU000].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU000].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU000].states =
{
	-- DevFrontEnd: allow
	"SETUP",
	"ESCAPE_CAVE_TAKE_THE_SEAL",
	"HERO_TEST_MUSIC_BOX", 
	"RENEGADE_CAMP_SAKER", 
	"GYPSY_CAMP_SABINE", 
	"HOBBE_CAVE_ARENA", 
	"MOURNINGWOOD_SWIFT_PROMISE", 
	"BOWERSTONE_RENOWN_BREAK", 
	"BOWERSTONE_PAGE_PROMISE", 
	"AURORA_KALIN_PROMISE", 
	"CASTLE_CORONATION", 
	"CASTLE_FOR_ALBION",
	"BOWERSTONE_MARKET_BATTLE"
}
ScriptActivation[ScriptCode.QU000].initial_levels =
{
	-- DevFrontEnd: allow
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule",
	"DemonDoors\\RoadToRule"
}
ScriptActivation[ScriptCode.QU000].initial_markers =
{
	-- DevFrontEnd: allow
	"QU000_Debug_PSETUP",
	"QU000_Debug_PESCAPE_CAVE_TAKE_THE_SEAL",
	"QU000_Debug_PHERO_TEST_MUSIC_BOX", 
	"QU000_Debug_PRENEGADE_CAMP_SAKER", 
	"QU000_Debug_PGYPSY_CAMP_SABINE", 
	"QU000_Debug_PHOBBE_CAVE_ARENA", 
	"QU000_Debug_PMOURNINGWOOD_SWIFT_PROMISE", 
	"QU000_Debug_PBOWERSTONE_RENOWN_BREAK", 
	"QU000_Debug_PBOWERSTONE_PAGE_PROMISE", 
	"QU000_Debug_PAURORA_KALIN_PROMISE", 
	"QU000_Debug_PCASTLE_CORONATION", 
	"QU000_Debug_PCASTLE_FOR_ALBION",
	"QU000_Debug_PBOWERSTONE_MARKET_BATTLE"
}
ScriptActivation[ScriptCode.QU000].AbleToRun = function ()

RunScript("MyMod/MyScriptActivation.lua")

return nil
end

-- ** --  QC010 - Opening -- ** --

ScriptActivation[ScriptCode.QC010] = {}
ScriptActivation[ScriptCode.QC010].name = "QC010_Opening"
ScriptActivation[ScriptCode.QC010].display_name = "Opening"
ScriptActivation[ScriptCode.QC010].start_chap = Chapters.Opening
ScriptActivation[ScriptCode.QC010].end_chap = Chapters.Escape
ScriptActivation[ScriptCode.QC010].states = 
{
	-- DevFrontEnd: allow
	"ACS_QC010_GAME_INTRO",
	"CHOOSE_CLOTHES",
	"LEAVE_ROOM", 
	"ELISE_INTRO_ICS",
	"ELISE_LOOKAT",
	"ELISE_RULING_CHOICE",
	"KITCHEN_SPEECH",
	"AFTER_SPEECH",
	"SPARRING_ROOM",
	"FLOURISH_CUTSCENE",
	"ACS_QC010_PROTEST_AT_CASTLE",
	"HEAD_TO_WARROOM",
	"ACS_QC010_OVERHEARD_PART_1", 
	"ACS_QC010_OVERHEARD_PART_2",
	"ACS_QC010_ELISE_JUDGEMENT", 
	"ACS_QC010_ELISE_JUDGEMENT_CHOOSE_NEITHER",
	"ACS_QC010_ELISE_JUDGEMENT_CHOOSE_PROTESTERS",
	"THAT_EVENING", 
	"GARDEN_GETAWAY", 
	"MAUSOLEUM_ENTRANCE"
}
ScriptActivation[ScriptCode.QC010].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle",  
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle"
}
ScriptActivation[ScriptCode.QC010].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC010_Debug_PINTRO", 
	"QC010_Debug_PCHOOSE_CLOTHES",
	"QC010_Debug_PLEAVE_ROOM", 
	"QC010_Debug_PELISE_INTRO_ICS",
	"QC010_Debug_PELISE_LOOKAT",
	"QC010_Debug_PELISE_RULING_CHOICE",
	"QC010_Debug_PKITCHEN_SPEECH",
	"QC010_Debug_PAFTER_SPEECH",
	"QC010_Debug_PSPARRING_ROOM",
	"QC010_Debug_PSPARRING_ROOM",
	"QC010_Debug_PPROTEST_LOOKAT",
	"QC010_Debug_PHEAD_TO_WARROOM",
	"QC010_Debug_PLOGAN_OVERHEARD_ICS", 
	"QC010_Debug_PCONFRONT_LOGAN",
	"QC010_Debug_PJUDGEMENT", 
	"QC010_Debug_PJUDGEMENT", 
	"QC010_Debug_PJUDGEMENT", 
	"QC010_Debug_PTHAT_EVENING", 
	"QC010_Debug_PGARDEN_GETAWAY", 
	"QC010_Debug_PMAUSOLEUM_ENTRANCE"
}

ScriptActivation[ScriptCode.QC010].AbleToRun = nil

-- ** --  QC015 - Escape -- ** --

ScriptActivation[ScriptCode.QC015] = {}
ScriptActivation[ScriptCode.QC015].name = "QC015_Escape"
ScriptActivation[ScriptCode.QC015].display_name = "Escape"
ScriptActivation[ScriptCode.QC015].start_chap = Chapters.Escape
ScriptActivation[ScriptCode.QC015].end_chap = Chapters.BrightwallHeroTest
ScriptActivation[ScriptCode.QC015].states = 
{
	-- DevFrontEnd: allow
	"INTRO",
	"TAKING_THE_SEAL_ICS",
	"BACK_FROM_WHITE_ROOM",
	"MAIN_CHAMBER", 
	"BAT_INTRO", 
	"OUTSIDE_SEWERS",
	"CULLIS_GATE",
	"GUI_ROOM"
}
ScriptActivation[ScriptCode.QC015].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\EscapeCave", 
	"Albion\\EscapeCave",
	"Albion\\EscapeCave", 
	"Albion\\EscapeCave",
	"Albion\\EscapeCave", 
	"Albion\\EscapeCave",
	"Albion\\EscapeCave", 
	"Albion\\EscapeCave"
}
ScriptActivation[ScriptCode.QC015].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC015_Debug_INTRO",
	"QC015_Debug_TAKING_THE_SEAL_ICS",
	"QC015_Debug_BACK_FROM_WHITE_ROOM",
	"QC015_Debug_MAIN_CHAMBER", 
	"QC015_Debug_BAT_INTRO", 
	"QC015_Debug_OUTSIDE_SEWERS",
	"QC015_Debug_CULLIS_GATE",
	"QC015_Debug_GUI_ROOM"
}
ScriptActivation[ScriptCode.QC015].AbleToRun = nil

-- ** --  QC020 - Becoming a Hero -- ** --

ScriptActivation[ScriptCode.QC020] = {}
ScriptActivation[ScriptCode.QC020].name = "QC020_BecomingAHero"
ScriptActivation[ScriptCode.QC020].display_name = "Hero Test"
ScriptActivation[ScriptCode.QC020].start_chap = Chapters.BrightwallHeroTest
ScriptActivation[ScriptCode.QC020].end_chap = Chapters.GypsiesAndRenegades_Part_1
ScriptActivation[ScriptCode.QC020].states = 
{
	-- DevFrontEnd: allow
	"APPEAR_IN_GYPSY_CAMP", 
	"GUI_CHANGE_CLOTHES", 
	"ACS_QC020_SabineIntro", 
	"CHOOSE_WEAPONS", 
	"MISTPEAK_VALLEY_START",
	"WOLF_INTRO", 
	"APPROACH_LIBRARIAN", 
	"ENTER_HERO_TEST", 
	"ENTER_MELEE_TEST_CHAMBER", 
	"HOLLOWMAN_INTRO", 
	"ENTER_YELLOW_CHAMBER", 
	"MAGIC_DOOR", 
	"ENTER_RED_CHAMBER", 
	"MUSIC_BOX"
}
ScriptActivation[ScriptCode.QC020].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\Mistpeak_GypsyCamp", 
	"Albion\\Mistpeak_GypsyCamp", 
	"Albion\\Mistpeak_GypsyCamp", 
	"Albion\\Mistpeak_GypsyCamp", 
	"Albion\\MistpeakValley", 
	"Albion\\MistpeakValley", 
	"Albion\\BrightwallVillage", 
	"Albion\\OldRepository",
	"Albion\\OldRepository",
	"Albion\\OldRepository",
	"Albion\\OldRepository",
	"Albion\\OldRepository",
	"Albion\\OldRepository",
	"Albion\\OldRepository"
}
ScriptActivation[ScriptCode.QC020].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC020_Debug_PAPPEAR_IN_GYPSY_CAMP", 
	"QC020_Debug_PGUI_CHANGE_CLOTHES", 
	"QC020_Debug_PAPPROACH_SABINE", 
	"QC020_Debug_PCHOOSE_WEAPONS", 
	"QC020_Debug_PMISTPEAK_VALLEY_START",
	"QC020_Debug_PWOLF_INTRO", 
	"QC020_Debug_PLIBRARY_INTRO",
	"QC020_Debug_PENTER_HERO_TEST", 
	"QC020_Debug_PENTER_MELEE_TEST_CHAMBER", 
	"QC020_Debug_PHOLLOWMAN_INTRO", 
	"QC020_Debug_PENTER_YELLOW_CHAMBER", 
	"QC020_Debug_PMAGIC_DOOR",
	"QC020_Debug_PENTER_RED_CHAMBER", 
	"QC020_Debug_PMUSIC_BOX"
}
ScriptActivation[ScriptCode.QC020].AbleToRun = nil

-- ** --  QC030 - Gypsies & Renegades pt1 -- ** --

ScriptActivation[ScriptCode.QC030] = {}
ScriptActivation[ScriptCode.QC030].name = "QC030_GypsiesAndRenegades_Part_1"
ScriptActivation[ScriptCode.QC030].display_name = "Mistpeak Valley Traders pt1"
ScriptActivation[ScriptCode.QC030].start_chap = Chapters.GypsiesAndRenegades_Part_1
ScriptActivation[ScriptCode.QC030].end_chap = Chapters.GypsiesAndRenegades_Part_2
ScriptActivation[ScriptCode.QC030].states = 
{
	-- DevFrontEnd: allow
	"TELEPORTED_ARRIVAL",
	"RETURN_TO_WALTER_ICS",
	"PASSED_OUT_RENEGADE",
	"EARN_MONEY",
	"BUY_TATTOO",
	"BUY_BEARD"
}
ScriptActivation[ScriptCode.QC030].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QC030].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC030_Debug_PTELEPORTED_ARRIVAL", 
	"QC030_Debug_PRETURN_TO_WALTER",
	"QC030_Debug_PPASSED_OUT_RENEGADE", 
	"QC030_Debug_PEARN_MONEY",
	"QC030_Debug_PBUY_TATTOO",
	"QC030_Debug_PBUY_BEARD"
}
ScriptActivation[ScriptCode.QC030].AbleToRun = nil

-- ** --  QC040 - Gypsies & Renegades pt2 -- ** --

ScriptActivation[ScriptCode.QC040] = {}
ScriptActivation[ScriptCode.QC040].name = "QC040_GypsiesAndRenegades_Part_2"
ScriptActivation[ScriptCode.QC040].display_name = "Mistpeak Valley Traders"
ScriptActivation[ScriptCode.QC040].start_chap = Chapters.GypsiesAndRenegades_Part_2
ScriptActivation[ScriptCode.QC040].end_chap = Chapters.CableCarAndHobbes
ScriptActivation[ScriptCode.QC040].states = {

	-- DevFrontEnd: allow
	"BANDIT_CAMP_GATE",
	"INSIDE_CAMP_ENTRANCE",
	"CAMP_COMBAT",
	"BOSS_INTRO_ICS",
	"FACTION_DECISION",
	"BRIGHTWALL_RETURN",
	-- DevFrontEnd: allow
	"BRIGHTWALL_RENOWN",
	"SAMUEL_PROMISE",
	"ACS_QC040_SabineOutro"
	
}
ScriptActivation[ScriptCode.QC040].initial_levels = {
	-- DevFrontEnd: allow
	"Albion\\MistpeakValley", 
	"Albion\\Mistpeak_RenegadeCamp",
	"Albion\\Mistpeak_RenegadeCamp",
	"Albion\\Mistpeak_RenegadeCamp",
	"Albion\\Mistpeak_RenegadeCamp",
	"Albion\\BrightwallVillage",
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\Mistpeak_GypsyCamp"
}
ScriptActivation[ScriptCode.QC040].initial_markers = {
	-- DevFrontEnd: allow
	"QC040_Debug_PBANDIT_CAMP_GATE",
	"QC040_Debug_PINSIDE_CAMP_ENTRANCE",
	"QC040_Debug_PCAMP_COMBAT",
	"QC040_Debug_PBOSS_INTRO",
	"QC040_Debug_PFACTION_DECISION",
	"QC040_Debug_PBRIGHTWALL_RETURN",
	-- DevFrontEnd: allow
	"QC040_Debug_PBRIGHTWALL_RENOWN",
	"QC040_Debug_PSAMUEL_PROMSIE",
	"QC040_Debug_POUTRO"
}
ScriptActivation[ScriptCode.QC040].AbleToRun = nil

-- ** --  QC050 - Cable Car and Hobbes -- ** --

ScriptActivation[ScriptCode.QC050] = {}
ScriptActivation[ScriptCode.QC050].name = "QC050_CableCarAndHobbes"
ScriptActivation[ScriptCode.QC050].display_name = "Cable Car and Hobbes"
ScriptActivation[ScriptCode.QC050].start_chap = Chapters.CableCarAndHobbes
ScriptActivation[ScriptCode.QC050].end_chap = Chapters.JourneyToBowerstoneIndustrial
ScriptActivation[ScriptCode.QC050].states =
{
	-- DevFrontEnd: allow
	"INTRO",
	"CABLE_CAR_CRASH_ICS",
	"BARRIER_BREAK",
	"ELEVATOR",
	"HOBBE_INTRO_ICS",
	"AMBUSH",
	"BAT_HOBBE",
	"CANYON",
	"HOBBE_ELITE_INTRO",
	"HOBBE_TOWN",
	"SUMMONER_BARRIER",
	"NARROWS",
	"FINAL_BATTLE",
	"BATTLE_OVER"
}
ScriptActivation[ScriptCode.QC050].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole",
	"Albion\\TheHole"
}
ScriptActivation[ScriptCode.QC050].initial_markers =
{
	-- DevFrontEnd: allow
	"QC050_Debug_CABLE_CAR_CRASH",
	"QC050_Debug_CABLE_CAR_CRASH",
	"QC050_Debug_BARRIER_BREAK",
	"QC050_Debug_ELEVATOR",
	"QC050_Debug_HOBBE_INTRO",
	"QC050_Debug_AMBUSH",
	"QC050_Debug_BAT_HOBBE",
	"QC050_Debug_CANYON",
	"QC050_Debug_HOBBE_ELITE_INTRO",
	"QC050_Debug_HOBBE_TOWN",
	"QC050_Debug_SUMMONER_BARRIER",
	"QC050_Debug_NARROWS",
	"QC050_Debug_FINAL_BATTLE",
	"QC050_Debug_BATTLE_OVER"
}
ScriptActivation[ScriptCode.QC050].AbleToRun = nil

-- ** --  QC060 - Mourningwood Fort Battle -- ** --

ScriptActivation[ScriptCode.QC060] = {}
ScriptActivation[ScriptCode.QC060].name = "QC060_MourningwoodFortBattle"
ScriptActivation[ScriptCode.QC060].display_name = "Mourningwood Fort Battle"
ScriptActivation[ScriptCode.QC060].start_chap = Chapters.JourneyToBowerstoneIndustrial
ScriptActivation[ScriptCode.QC060].end_chap = Chapters.BowerstoneAndBalverines_Part_1
ScriptActivation[ScriptCode.QC060].states = 
{
	-- DevFrontEnd: allow
	"ARRIVAL_IN_MOURNINGWOOD",
	"ENTER_FORT",
	"START_FORT_SIM",
	"MORTAR_TUTORIAL",
	"HOLLOWMAN_INTRO_ICS",
	"HOLLOWMAN_FIGHT_OUTSIDE",
	"HOLLOWMAN_FIGHT_INSIDE",
	"HOLLOWMAN_SIMMONS_INTRO_ICS",
	"QUEST_OUTRO" 
}
ScriptActivation[ScriptCode.QC060].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves"
}
ScriptActivation[ScriptCode.QC060].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC060_Debug_PARRIVAL_IN_MOURNINGWOOD", 
	"QC060_Debug_PENTER_FORT", 
	"QC060_Debug_PSTART_FORT_SIM", 
	"QC060_Debug_PMORTAR_TUTORIAL", 
	"QC060_Debug_PHOLLOWMAN_INTRO_ICS",
	"QC060_Debug_PHOLLOWMAN_FIGHT_OUTSIDE",
	"QC060_Debug_PHOLLOWMAN_FIGHT_INSIDE",
	"QC060_Debug_PHOLLOWMAN_SIMMONS_INTRO_ICS",
	"QC060_Debug_PQUEST_OUTRO"
}
ScriptActivation[ScriptCode.QC060].AbleToRun = nil


ScriptActivation[ScriptCode.QC070] = {}
ScriptActivation[ScriptCode.QC070].name = "QC070_BowerstoneAndBalverines_Part_1"
ScriptActivation[ScriptCode.QC070].display_name = "Bowerstone And Balverines - Part 1"
ScriptActivation[ScriptCode.QC070].start_chap = Chapters.BowerstoneAndBalverines_Part_1
ScriptActivation[ScriptCode.QC070].end_chap = Chapters.BowerstoneAndBalverines_Part_2
ScriptActivation[ScriptCode.QC070].states = 
{
	-- DevFrontEnd: allow
	"START", 
	"BOWERSTONE_INDUSTRIAL", 	
	"ACS_QC070_REAVERS_SPEECH", 
	"ACS_QC070_PAGE_INTRO", 
	"RESISTANCE",
	"RENOWN_BREAK",
	"MISSION",
	"REAVER_MANOR", 
	"END"
}
ScriptActivation[ScriptCode.QC070].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneIndustrial", 
	"Albion\\BowerstoneIndustrial", 
	"Albion\\BowerstoneIndustrial", 
	"Albion\\Sewers", 
	"Albion\\Sewers", 
	"Albion\\Sewers", 
	"Albion\\Sewers", 
	"Albion\\NewMillfields",
	"Albion\\HawneManorCellars"
}
ScriptActivation[ScriptCode.QC070].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC070_Debug_PSTART", 
	"QC070_Debug_PBOWERSTONE_INDUSTRIAL", 
	"QC070_Debug_PDEMONSTRATORS", 
	"QC070_Debug_PPAGE_INTRO", 
	"QC070_Debug_PRESISTANCE", 
	"QC070_Debug_PRESISTANCE", 
	"QC070_Debug_PRESISTANCE",
	"QC070_Debug_PHAWNE_MANOR", 
	"QC070_Debug_PENTER_CELLAR"
}
ScriptActivation[ScriptCode.QC070].AbleToRun = nil


ScriptActivation[ScriptCode.QC080] = {}
ScriptActivation[ScriptCode.QC080].name = "QC080_BowerstoneAndBalverines_Part_2"
ScriptActivation[ScriptCode.QC080].display_name = "Bowerstone and Balverines - Part 2"
ScriptActivation[ScriptCode.QC080].start_chap = Chapters.BowerstoneAndBalverines_Part_2
ScriptActivation[ScriptCode.QC080].end_chap = Chapters.BowerstoneBoat
ScriptActivation[ScriptCode.QC080].states = 
{
	-- DevFrontEnd: allow
	"MANOR_INTRO", 
	"ACS_REAVERS_LAIR_INTRO", 
	"HOBBE_ROOM",
	"HOBBE_ROOM_OUTRO",
	"HOLLOWMAN_ROOM", 
	"HOLLOWMAN_ROOM_OUTRO", 
	"RENEGADE_ROOM", 
	"RENEGADE_ROOM_OUTRO", 
	"DERVISH_ROOM", 
	"DERVISH_ROOM_OUTRO", 
	"BALVERINE_INTRO", 
	"ACS_REAVERS_LAIR_OUTRO", 
	"TOWN_CRIER_ANNOUNCEMENT",
	"END"
}
ScriptActivation[ScriptCode.QC080].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars", 
	"Albion\\HawneManorCellars",
	"Albion\\NewMillfields",
	"Albion\\NewMillfields"
}
ScriptActivation[ScriptCode.QC080].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC080_Debug_PMANOR_INTRO", 
	"QC080_Debug_PREAVERS_LAIR_INTRO",
	"QC080_Debug_PHOBBE_ROOM", 
	"QC080_Debug_PHOBBE_ROOM_OUTRO",
	"QC080_Debug_PSECOND_ROOM", 
	"QC080_Debug_PSECOND_ROOM_OUTRO", 
	"QC080_Debug_PTHIRD_ROOM", 
	"QC080_Debug_PTHIRD_ROOM_OUTRO", 
	"QC080_Debug_PFOURTH_ROOM", 
	"QC080_Debug_PFOURTH_ROOM_OUTRO", 
	"QC080_Debug_PBALVERINE_INTRO", 
	"QC080_Debug_PREAVER_OUTRO", 
	"Travel_NMF_Manor",
	"Travel_NMF_Manor"
}
ScriptActivation[ScriptCode.QC080].AbleToRun = nil

ScriptActivation[ScriptCode.QC090] = {}
ScriptActivation[ScriptCode.QC090].name = "QC090_BowerstoneBoat"
ScriptActivation[ScriptCode.QC090].display_name = "Bowerstone Boat"
ScriptActivation[ScriptCode.QC090].start_chap = Chapters.BowerstoneBoat
ScriptActivation[ScriptCode.QC090].end_chap = Chapters.ShadeLightDungeon
ScriptActivation[ScriptCode.QC090].states = 
{
	-- DevFrontEnd: allow
	"ACS_QC090_LogansSpeech", 
	"ENTER_RESISTANCE_HQ", 
	"LOGAN_SOLDIER_SECTION",
	"SHIP_EXPLOSIONS",
	"DEFEAT_THE_GUARDS"
}
ScriptActivation[ScriptCode.QC090].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle", 
	"Albion\\Sewers",
	"Albion\\BowerstoneIndustrial",
	"Albion\\BowerstoneIndustrial",
	"Albion\\BowerstoneIndustrial"
}
ScriptActivation[ScriptCode.QC090].initial_markers =  
{
	-- DevFrontEnd: allow
	"QC090_Debug_PFAIRFAX_CASTLE_SPEECH", 
	"QC090_Debug_PENTER_RESISTANCE_HQ", 
	"QC090_Debug_PLOGAN_SOLDIER_SECTION", 
	"QC090_Debug_PSHIP_EXPLOSIONS", 
	"QC090_Debug_PDEFEAT_THE_GUARDS"
}

ScriptActivation[ScriptCode.QC090].initial_scenarios = 
{
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
}

ScriptActivation[ScriptCode.QC090].AbleToRun = nil
ScriptActivation[ScriptCode.QC100] = {}
ScriptActivation[ScriptCode.QC100].name = "QC100_ShadeLightDungeon"
ScriptActivation[ScriptCode.QC100].display_name = "Shadelight Dungeon"
ScriptActivation[ScriptCode.QC100].start_chap = Chapters.ShadeLightDungeon
ScriptActivation[ScriptCode.QC100].end_chap = Chapters.AuroraPartOne
ScriptActivation[ScriptCode.QC100].states =
{
	-- DevFrontEnd: allow
	"START",
	"BEACH", 
	"BATS", 
	"CAVE_WALK", 
	"SEE_BARRIER", 
	"DISCOVER_BOOK", 
	"OPEN_PORTAL", 
	"ENTER_DUNGEON", 
	"DOG_AND_TORCH", 
	"WALK_TO_BRIDGE", 
	"BRIDGE_SCENE", 
	"CROSS_DIVIDE", 
	"PULL_LEVER", 
	"BRIDGE_FIXED", 
	"SCHOLAR_DOOR", 
	"WHISPERS", 
	"SHADOW_INTRO", 
	"SHADOW_FIGHT", 
	"BAT_ATTACK", 
	"CRAWLER_INTRO_ONE", 
	"CRAWLER_INTRO_TWO", 
	"CRAWLER_INTRO_ACS", 
	"WALK_TO_AMBUSH", 
	"AMBUSH", 
	"WALTER_THROWS_TORCH", 
	"WALK_TO_LEDGE", 
	"LEDGE_JUMP", 
	"SHADOW_POOLS", 
	"SEE_CAPTURED_WALTER", 
	"NIGHTCRAWLER_FIGHT_SHADOWS", 
	"NIGHTCRAWLER_FIGHT_MINIONS", 
	"NIGHTCRAWLER_FIGHT_SENTINEL", 
	"SAVE_WALTER", 
	"EXIT"
}
ScriptActivation[ScriptCode.QC100].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\IsleOfMists",
	"Albion\\IsleOfMists", 
	"Albion\\IsleOfMists", 
	"Albion\\IsleOfMists", 
	"Albion\\IsleOfMists", 
	"Albion\\IsleOfMists", 
	"Albion\\IsleOfMists",
	"Albion\\IsleOfMists", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight", 
	"Albion\\ShadeLight"
}
ScriptActivation[ScriptCode.QC100].initial_markers =
{
	-- DevFrontEnd: allow
	"QC100_Debug_PTHERESA",
	"QC100_Debug_PBEACH", 
	"QC100_Debug_PBATS", 
	"QC100_Debug_PBATS", 
	"QC100_Debug_PSEE_BARRIER", 
	"QC100_Debug_PDISCOVER_BOOK", 
	"QC100_Debug_PDISCOVER_BOOK", 
	"QC100_Debug_PDISCOVER_BOOK", 
	"QC100_Debug_PDOG_AND_TORCH", 
	"QC100_Debug_PWALK_TO_BRIDGE", 
	"QC100_Debug_PBRIDGE_SCENE", 
	"QC100_Debug_PCROSS_DIVIDE", 
	"QC100_Debug_PPULL_LEVER", 
	"QC100_Debug_PBRIDGE_FIXED", 
	"QC100_Debug_PSCHOLAR_DOOR", 
	"QC100_Debug_PWHISPERS", 
	"QC100_Debug_PSHADOW_INTRO", 
	"QC100_Debug_PSHADOW_FIGHT", 
	"QC100_Debug_PSHADOW_FIGHT", 
	"QC100_Debug_PCRAWLER_INTRO_ONE", 
	"QC100_Debug_PCRAWLER_INTRO_TWO", 
	"QC100_Debug_PCRAWLER_INTRO_ACS", 
	"QC100_Debug_PCRAWLER_INTRO_ACS", 
	"QC100_Debug_PAMBUSH", 
	"QC100_Debug_PAMBUSH", 
	"QC100_Debug_PAMBUSH", 
	"QC100_Debug_PLEDGE_JUMP", 
	"QC100_Debug_PSHADOW_POOLS", 
	"QC100_Debug_PSEE_CAPTURED_WALTER", 
	"QC100_Debug_PNIGHTCRAWLER_FIGHT", 
	"QC100_Debug_PNIGHTCRAWLER_FIGHT", 
	"QC100_Debug_PNIGHTCRAWLER_FIGHT", 
	"QC100_Debug_PNIGHTCRAWLER_FIGHT", 
	"QC100_Debug_PNIGHTCRAWLER_FIGHT"
}
ScriptActivation[ScriptCode.QC100].AbleToRun = nil

ScriptActivation[ScriptCode.QC110] = {}
ScriptActivation[ScriptCode.QC110].name = "QC110_AuroraPart1"
ScriptActivation[ScriptCode.QC110].display_name = "Aurora Part 1"
ScriptActivation[ScriptCode.QC110].start_chap = Chapters.AuroraPartOne
ScriptActivation[ScriptCode.QC110].end_chap = Chapters.Aurora_Part_2
ScriptActivation[ScriptCode.QC110].states = 
{
	-- DevFrontEnd: allow
	"ENTER_DESERT",
	"LEAD_WALTER", 
	"WALTER_CHOICE",
	"ACS_QC110_WALTER_COLLAPSE",
	"WALK_DESERT", 
	"TABLE_WALTER", 
	"TORTURED_WALTER", 
	"FIGHT_WALTER", 
	"SHADOW_WALTER_STORY",
	"COLLAPSE",
	"ACS_QC110_HERO_COLLAPSE"
}
ScriptActivation[ScriptCode.QC110].initial_levels = 
{
	-- DevFrontEnd: allow
	"Aurora\\TheDesert",
	"Aurora\\TheDesert",
	"Aurora\\TheDesert",
	"Aurora\\TheDesert",
	"Aurora\\TheDesert",
	"Aurora\\TheDesert",
	"Aurora\\TheDesert", 
	"Aurora\\TheDesert",
	"Aurora\\TheDesert",
	"Aurora\\TheDesert", 
	"Aurora\\TheDesert"
}
ScriptActivation[ScriptCode.QC110].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario", 
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario", 
	"DefaultScenario",
}
ScriptActivation[ScriptCode.QC110].initial_markers = 
{
	"QC110_Debug_PENTER_DESERT", 
	"QC110_Debug_PENTER_DESERT", 
	"QC110_Debug_PWALTER_CHOICE",
	"QC110_Debug_PWALTER_CHOICE",
	"QC110_Debug_PDESERT_WALK",
	"QC110_Debug_PDESERT_WEIRD",
	"QC110_Debug_PDESERT_WEIRD", 
	"QC110_Debug_PDESERT_WEIRD",
	"QC110_Debug_PDESERT_WEIRD",
	"QC110_Debug_PDESERT_WEIRD", 
	"QC110_Debug_PDESERT_WEIRD", 

}
ScriptActivation[ScriptCode.QC110].AbleToRun = nil

ScriptActivation[ScriptCode.QC120] = {}
ScriptActivation[ScriptCode.QC120].name = "QC120_Aurora_Part_2"
ScriptActivation[ScriptCode.QC120].display_name = "Aurora Part 2"
ScriptActivation[ScriptCode.QC120].start_chap = Chapters.Aurora_Part_2
ScriptActivation[ScriptCode.QC120].end_chap = Chapters.BowerstoneCastleBattle
ScriptActivation[ScriptCode.QC120].states = 
{
	-- DevFrontEnd: allow
	"ACS_QC120_KALIN_INTRO",
	"WALK_OUT",
	"EXPLORE",
	"PROMISE",
	"ACS_QC120_WALTER_WAKING_UP",
	"SHIP",
	"GOODBYE"
}
ScriptActivation[ScriptCode.QC120].initial_levels = 
{
	-- DevFrontEnd: allow
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare",
	"Albion\\CastleBattle"
}
ScriptActivation[ScriptCode.QC120].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"Wrecked",
	"Wrecked",
	"Wrecked",
	"Wrecked",
	"Wrecked",
	"Wrecked",
	"DefaultScenario"
}
ScriptActivation[ScriptCode.QC120].initial_markers = 
{
	"QC120_Debug_PAWAKE",
	"QC120_Debug_PAWAKE",
	"QC120_Debug_PEXPLORE",
	"QC120_Debug_PPROMISE",
	"QC120_Debug_PWALTERWAKE",
	"QC120_Debug_PWALTERWAKE",
	"QC120_Debug_PWALTERWAKE"
}
ScriptActivation[ScriptCode.QC120].AbleToRun = nil

ScriptActivation[ScriptCode.QC130] = {}
ScriptActivation[ScriptCode.QC130].name = "QC130_BowerstoneCastleBattle"
ScriptActivation[ScriptCode.QC130].display_name = "Bowerstone Castle Battle"
ScriptActivation[ScriptCode.QC130].start_chap = Chapters.BowerstoneCastleBattle
ScriptActivation[ScriptCode.QC130].end_chap = Chapters.Coronation
ScriptActivation[ScriptCode.QC130].states = 
{
	-- DevFrontEnd: allow
	"ACS_QC130_MeetingTheGenerals", 
	"BEACH_ARRIVAL", 
	"CANNON_INTRO", 
	"FRONT_GATE_OPEN", 
	"HOUSE_COLLAPSE", 
	"ROOF_TOP", 
	"BRIDGE_GATE_OPEN", 
	"CASTLE_MORTAR_INTRO", 
	"OUTRO", 
	"ACS_QC130_LoganConfrontation"
	}
ScriptActivation[ScriptCode.QC130].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\CastleBattle", 
	"Albion\\BowerstoneCastle"
}

ScriptActivation[ScriptCode.QC130].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario"
}
ScriptActivation[ScriptCode.QC130].initial_markers = 
{
	"QC130_Debug_PACS_QC130_MeetingTheGenerals", 
	"QC130_Debug_PBEACH_ARRIVAL", 
	"QC130_Debug_PCANNON_INTRO", 
	"QC130_Debug_PFRONT_GATE_OPEN", 
	"QC130_Debug_PHOUSE_COLLAPSE", 
	"QC130_Debug_PROOF_TOP", 
	"QC130_Debug_PBRIDGE_GATE_OPEN", 
	"QC130_Debug_PCASTLE_MORTAR_INTRO", 
	"QC130_Debug_POUTRO",
	"QC130_Debug_PACS_QC130_LoganConfrontation" 
}
ScriptActivation[ScriptCode.QC130].AbleToRun = nil

-- ** --  QC140 - Coronation -- ** --

ScriptActivation[ScriptCode.QC140] = {}
ScriptActivation[ScriptCode.QC140].name = "QC140_Coronation"
ScriptActivation[ScriptCode.QC140].display_name = "Coronation"
ScriptActivation[ScriptCode.QC140].start_chap = Chapters.Coronation
ScriptActivation[ScriptCode.QC140].end_chap = Chapters.Ruling_Part1
ScriptActivation[ScriptCode.QC140].states = 
{
	-- DevFrontEnd: allow
	"START", 
	"ACS_QC140_CORONATION",
	"HOBSON",
	"ACS_QC140_LOGAN_JUDGEMENT",
	"JUDGEMENT_DECISION",
	"ACS_QC140_LOGAN_EXECUTED",
	"FAKE_HERO_FAMILY",
	"VICTORY_BRIAN",
	"THERESA_ENCOUNTER",
}
ScriptActivation[ScriptCode.QC140].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle"
}
ScriptActivation[ScriptCode.QC140].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
}
ScriptActivation[ScriptCode.QC140].initial_markers = 
{
	"QC140_Debug_PCORONATION_START", 
	"QC140_Debug_PCORONATION_START", 
	"QC140_Debug_PCORONATION_START", 
	"QC140_Debug_PJUDGEMENT", 
	"QC140_Debug_PJUDGEMENT",
	"QC140_Debug_PJUDGEMENT", 
	"QC140_Debug_PJUDGEMENT",
	"QC140_Debug_PJUDGEMENT", 
	"QC140_Debug_PJUDGEMENT", 
}
ScriptActivation[ScriptCode.QC140].AbleToRun = nil

-- ** --  QC150 - Ruling Part One -- ** --

ScriptActivation[ScriptCode.QC150] = {}
ScriptActivation[ScriptCode.QC150].name = "QC150_Ruling_Part1"
ScriptActivation[ScriptCode.QC150].display_name = "Ruling Part One"
ScriptActivation[ScriptCode.QC150].start_chap = Chapters.Ruling_Part1
ScriptActivation[ScriptCode.QC150].end_chap = Chapters.Ruling_Part2
ScriptActivation[ScriptCode.QC150].states = 
{
	-- DevFrontEnd: allow
	"FIRST_WAR_COUNCIL",
	"ENTER_THE_TREASURY",
	"HOBSON_TREASURY",
	"MEET_WITH_REAVER",
	"RETURN_TO_WAR_ROOM",
}
ScriptActivation[ScriptCode.QC150].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneIndustrial",
	"Albion\\BowerstoneCastle",
}
ScriptActivation[ScriptCode.QC150].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
}
ScriptActivation[ScriptCode.QC150].initial_markers = 
{
	"QC150_Debug_PRULING_START",
	"QC150_Debug_PRULING_START",
	"QC150_Debug_PRULING_TREASURY",
	"QC150_Debug_PREAVER_MEETING",
	"QC150_Debug_PRULING_START",
}
ScriptActivation[ScriptCode.QC150].AbleToRun = nil

-- ** --  QC160 - Ruling Part Two -- ** --

ScriptActivation[ScriptCode.QC160] = {}
ScriptActivation[ScriptCode.QC160].name = "QC160_Ruling_Part2"
ScriptActivation[ScriptCode.QC160].display_name = "Ruling Part Two"
ScriptActivation[ScriptCode.QC160].start_chap = Chapters.Ruling_Part2
ScriptActivation[ScriptCode.QC160].end_chap = Chapters.BowerstoneMarketBattle
ScriptActivation[ScriptCode.QC160].states = 
{
		-- DevFrontEnd: allow
		"OLD_QUARTER_JUDGEMENT",			-- castle
		"STOLEN_SPOUSE",					-- castle
		"FIRST_TREASURY_END",				-- castle
		"GUARD_CHOICE",						-- castle
		"REDECORATE_CASTLE",				-- castle
		"SETUP_AURORA_JUDGEMENT",			-- castle
		"JUDGE_AURORA",						-- castle
		"DERVISH_SLAVES_QUEST",				-- castle
		"SECOND_TREASURY_END",				-- castle
		"KID_TAX_BREAK_CHOICE",				-- castle
		"ORPHANAGE_JUDGEMENT",				-- castle
		"SEWAGE_JUDGEMENT",					-- castle
		"SLAVE_TRADE_QUEST",				-- sewers
		"THIRD_TREASURY_END",				-- castle
		"DRINKING_LIMIT_CHOICE",			-- castle
		"SETUP_LIBRARY_JUDGEMENT",			-- castle
		"JUDGE_LIBRARY",					-- castle
		"DRAIN_LAKE_JUDGEMENT",				-- castle
		"BALVERINE_FOREST_QUEST",			-- millfields
		"FOURTH_TREASURY_END",				-- castle
		"DYING_DOG_CHOICE",					-- castle
		"DESERT_FORT_JUDGEMENT",			-- castle
		"SETUP_MISTPEAK_JUDGEMENT",			-- castle
		"JUDGE_MISTPEAK",					-- castle
		"COMMISSION_ARMY",					-- castle
		"FIFTH_TREASURY_END",				-- castle
		"VISIT_TO_THE_ROAD",				-- castle
		"RETURN_TO_WAR_ROOM",				-- castle
}
ScriptActivation[ScriptCode.QC160].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\Sewers",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\NewMillFields",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
}
ScriptActivation[ScriptCode.QC160].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
	"DefaultScenario",
}
ScriptActivation[ScriptCode.QC160].initial_markers = 
{
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PSEWERS_START",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PMILLFIELDS_START",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
	"QC160_Debug_PROAD_TO_RULE",
}
ScriptActivation[ScriptCode.QC160].AbleToRun = nil

-- ** --  QC170 - Bowerstone Market Battle -- ** --

ScriptActivation[ScriptCode.QC170] = {}
ScriptActivation[ScriptCode.QC170].name = "QC170_BowerstoneMarketBattle"
ScriptActivation[ScriptCode.QC170].display_name = "Bowerstone Market Battle"
ScriptActivation[ScriptCode.QC170].start_chap = Chapters.BowerstoneMarketBattle
ScriptActivation[ScriptCode.QC170].end_chap = Chapters.EndGame
ScriptActivation[ScriptCode.QC170].states = 
{
	-- DevFrontEnd: allow
	"BOWERSTONE_START",
	"FIRST_SENTINEL",
	"SECOND_SENTINEL",
	"SHADOW_WALTER_INTRO",
	"WALTER_FIGHT",
	"ACS_QC170_WalterDying"
}
ScriptActivation[ScriptCode.QC170].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BWSMarket",
	"Albion\\BWSMarket",
	"Albion\\BWSMarket",
	"Albion\\BWSMarket",
	"Albion\\BWSMarket", 
	"Albion\\BWSMarket",
}
ScriptActivation[ScriptCode.QC170].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"EndBattleScenario",
	"EndBattleScenario",
	"EndBattleScenario",
	"EndBattleScenario",
	"EndBattleScenario",
	"EndBattleScenario",
}
ScriptActivation[ScriptCode.QC170].initial_markers = 
{
	-- DevFrontEnd: allow
	"QC170_Debug_PBOWERSTONE_START",
	"QC170_Debug_PFIRST_SENTINEL",
	"QC170_Debug_PSECOND_SENTINEL",
	"QC170_Debug_PSHADOW_WALTER_INTRO",
	"QC170_Debug_PWALTER_FIGHT",
	"QC170_Debug_PWALTER_FIGHT"
}
ScriptActivation[ScriptCode.QC170].AbleToRun = nil

ScriptActivation[ScriptCode.QC180] = {}
ScriptActivation[ScriptCode.QC180].name = "QC180_EndGame"
ScriptActivation[ScriptCode.QC180].display_name = "End Game"
ScriptActivation[ScriptCode.QC180].start_chap = Chapters.EndGame
ScriptActivation[ScriptCode.QC180].end_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC180].states =
{
	-- DevFrontEnd: allow
	"START_EVIL",
	"START_GOOD",
	"WALTER_STATUE", 
	"GENERALS", 
	"TEN_SHOT", 
	"THERESA", 
	"END"
}
ScriptActivation[ScriptCode.QC180].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle",
	"Albion\\BowerstoneCastle"
}

ScriptActivation[ScriptCode.QC180].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"EVIL",
	"GOOD",
	"GOOD",
	"GOOD",
	"GOOD",
	"GOOD",
	"GOOD",
}

ScriptActivation[ScriptCode.QC180].initial_markers =
{
	-- DevFrontEnd: allow
	"QC180_Debug_PSTART",
	"QC180_Debug_PSTART",
	"QC180_Debug_PSTART",
	"QC180_Debug_PSTART",
	"QC180_Debug_PSTART",
	"QC180_Debug_PSTART",
	"QC180_Debug_PSTART"
}
ScriptActivation[ScriptCode.QC180].AbleToRun = nil

-- ** --  QC999 - SANDBOX -- ** --

ScriptActivation[ScriptCode.QC999] = {}
ScriptActivation[ScriptCode.QC999].name = "QC999_Sandbox"
ScriptActivation[ScriptCode.QC999].display_name = "Sandbox"
ScriptActivation[ScriptCode.QC999].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC999].end_chap = Chapters.End

ScriptActivation[ScriptCode.QC999].states = 
{
	-- DevFrontEnd: allow
	"START"
}
ScriptActivation[ScriptCode.QC999].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle"
}
ScriptActivation[ScriptCode.QC999].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"DefaultScenario",
}
ScriptActivation[ScriptCode.QC999].initial_markers = 
{
	-- DevFrontEnd: allow
	"PlayerStart"
}

ScriptActivation[ScriptCode.QC999].AbleToRun = nil

-- // --  O P T I O N A L S  -- // --
ScriptActivation[ScriptCode.QO010] = {}
ScriptActivation[ScriptCode.QO010].name = "QO010_BrightwallBooks"
ScriptActivation[ScriptCode.QO010].display_name = "Brightwall Books"
ScriptActivation[ScriptCode.QO010].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QO010].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO010].states = 
{
	-- DevFrontEnd: allow
	"INTRO", 
	"ACCEPTED_QUEST", 
	"COLLECT_FIVE_BOOKS",
	"COLLECT_SPECIAL_BOOK_ONE",
	"COLLECT_TEN_BOOKS",
	"COLLECT_SPECIAL_BOOK_TWO",
	"COLLECT_FIFTEEN_BOOKS",
	"COLLECT_SPECIAL_BOOK_THREE",
	"COLLECT_TWENTY_BOOKS",
	"COLLECT_SPECIAL_BOOK_FOUR",
	"COLLECT_TWENTY_FIVE_BOOKS",
	"COLLECT_SPECIAL_BOOK_FIVE",
	"END"
}
ScriptActivation[ScriptCode.QO010].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QO010].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM", 
	"QO010_Debug_PPLINTH_ROOM"
}
ScriptActivation[ScriptCode.QO010].AbleToRun = nil

ScriptActivation[ScriptCode.QO020] = {}
ScriptActivation[ScriptCode.QO020].name = "QO020_Gnomes_Part_1"
ScriptActivation[ScriptCode.QO020].display_name = "Gnomes are great!"
ScriptActivation[ScriptCode.QO020].start_chap = Chapters.GypsiesAndRenegades_Part_2_RenownBreak
ScriptActivation[ScriptCode.QO020].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO020].states = 
{
	-- DevFrontEnd: allow
	"MEET_BRIAN", 
	"SEARCH_FOR_GARGOYLE", 
	"RETURN_TO_BRIAN", 
	"PLACE_GARGOYLE",
	"BRIAN_OUTRO",
	"GARGOYLE_AWAKENING",
	"GNOMES_ALIVE"
}
ScriptActivation[ScriptCode.QO020].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage",
	"Albion\\MistpeakValley",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QO020].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO020_Debug_PMEET_BRIAN", 
	"QO020_Debug_PSEARCH_FOR_GARGOYLE", 
	"QO020_Debug_PMEET_BRIAN", 
	"QO020_Debug_PMEET_BRIAN",
	"QO020_Debug_PMEET_BRIAN",
	"QO020_Debug_PMEET_BRIAN",
	"QO020_Debug_PMEET_BRIAN"
}
ScriptActivation[ScriptCode.QO020].AbleToRun = function()

	if Gameflow.InitialQuest == ScriptCode.QO030 then
		return false
	else
		return true
	end
end

ScriptActivation[ScriptCode.QO030] = {}
ScriptActivation[ScriptCode.QO030].name = "QO030_Gnomes_Part_2"
ScriptActivation[ScriptCode.QO030].display_name = "Gnomes are evil!"
ScriptActivation[ScriptCode.QO030].start_chap = Chapters.GypsiesAndRenegades_Part_2_RenownBreak
ScriptActivation[ScriptCode.QO030].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO030].states = 
{
	-- DevFrontEnd: allow
	"MEET_BRIAN_REDUX",
	"GNOME_TO_THE_SLAUGHTER",
	"GNOME_HUNT",
	"KILL_THE_GARGOYLE",
	"QUEST_COMPLETE"
}
ScriptActivation[ScriptCode.QO030].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QO030].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO030_Debug_PMEET_BRIAN_REDUX",
	"QO030_Debug_PMEET_BRIAN_REDUX",
	"QO030_Debug_PMEET_BRIAN_REDUX",
	"QO030_Debug_PMEET_BRIAN_REDUX",
	"QO030_Debug_PMEET_BRIAN_REDUX"
}
ScriptActivation[ScriptCode.QO030].AbleToRun = function()

	if Gameflow.InitialQuest == ScriptCode.QO030 or
		( ( QuestTracker.IsRegistered(QuestManager.HeroEntity, "QO020_Gnomes_Part_1") and QuestTracker.IsCompleted(QuestManager.HeroEntity, "QO020_Gnomes_Part_1")) and not IsLevelLoaded("Albion\\BrightwallVillage") ) then
			return true
	end
end


-- QO040 Chicken Chaser
ScriptActivation[ScriptCode.QO040] = {}
ScriptActivation[ScriptCode.QO040].name = "QO040_ChickenChaser"
ScriptActivation[ScriptCode.QO040].display_name = "Chicken Chaser"
ScriptActivation[ScriptCode.QO040].start_chap = Chapters.GypsiesAndRenegades_Part_2_RenownBreak
ScriptActivation[ScriptCode.QO040].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO040].states = 
{
	-- DevFrontEnd: allow
	"START", 
	"WAIT_TO_HUNT", 
	"CHICKEN_HUNT", 
	"ALL_BACK", 
	"JUDGEMENT",
	"OUTRO",
}
ScriptActivation[ScriptCode.QO040].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
}
ScriptActivation[ScriptCode.QO040].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO040_Debug_PINTRO", 
	"QO040_Debug_PCHICKEN_HUNT", 
	"QO040_Debug_PCHICKEN_HUNT", 
	"QO040_Debug_PCHICKEN_HUNT", 
	"QO040_Debug_PCHICKEN_HUNT",
	"QO040_Debug_PCHICKEN_HUNT"
}
ScriptActivation[ScriptCode.QO040].AbleToRun = function()

	if Gameflow.InitialQuest == ScriptCode.QV020 then
		return false
	else
		return true
	end
end

ScriptActivation[ScriptCode.QO050] = {}
ScriptActivation[ScriptCode.QO050].name = "QO050_MissingPlay"
ScriptActivation[ScriptCode.QO050].display_name = "Missing Play"
ScriptActivation[ScriptCode.QO050].start_chap = Chapters.GypsiesAndRenegades_Part_2_RenownBreak
ScriptActivation[ScriptCode.QO050].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO050].states = 
{
	-- DevFrontEnd: allow
	"MEET_ACTORS",
	"POST_ARGUMENT", 
	"FIND_BOOK", 
	"FIRST_PLAY", 
	"SECOND_PLAY", 
	"THIRD_PLAY", 
	"RETURN_BOOK", 
	"THE_ACTORS_ACT", 
	"QUEST_COMPLETE"
}
ScriptActivation[ScriptCode.QO050].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Optional\\TheLostWorks",
	"Optional\\TheLostWorks",
	"Optional\\TheLostWorks",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QO050].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO050_Debug_PMEET_ACTORS",
	"QO050_Debug_PMEET_ACTORS", 
	"QO050_Debug_PFIND_BOOK", 
	"QO050_Debug_PFIRST_PLAY", 
	"QO050_Debug_PSECOND_PLAY", 
	"QO050_Debug_PTHIRD_PLAY", 
	"QO050_Debug_PMEET_ACTORS", 
	"QO050_Debug_PMEET_ACTORS", 
	"QO050_Debug_PMEET_ACTORS"
}
ScriptActivation[ScriptCode.QO050].AbleToRun = nil

ScriptActivation[ScriptCode.QO080] = {}
ScriptActivation[ScriptCode.QO080].name = "QO080_AHeroesQuest"
ScriptActivation[ScriptCode.QO080].display_name = "TableTop"
ScriptActivation[ScriptCode.QO080].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QO080].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO080].states = 
{
	-- DevFrontEnd: allow
	"INTRO", 
	"ACCEPTED", 
	"FOUND_ORB", 
	"FAKE_QUEST_GIVER_FOUND", 
	"ENTERED_TOWER", 
	"SWITCH_ROOM",
	"ENTERED_CAVERN", 
	"EXIT_CAVERN", 
	"COMPLETE", 
	"OUTRO"
}
ScriptActivation[ScriptCode.QO080].initial_levels = 
{
	-- DevFrontEnd: allow
	"albion\\BWSMarket",
	"albion\\BWSMarket",
	"albion\\BWSMarket", 
	"optional\\Tabletop",
	"optional\\Tabletop",
	"optional\\Tabletop",
	"optional\\Tabletop",
	"optional\\Tabletop",
	"optional\\Tabletop",
	"albion\\BWSMarket"
}
ScriptActivation[ScriptCode.QO080].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO080_Debug_PINTRO", 
	"QO080_Debug_PACCEPTED", 
	"QO080_Debug_PFOUND_ORB", 
	"QO080_Debug_PFAKE_QUEST_GIVER_FOUND", 
	"QO080_Debug_PENTERED_TOWER", 
	"QO080_Debug_PSWITCH_ROOM",
	"QO080_Debug_PENTERED_CAVERN", 
	"QO080_Debug_PEXIT_CAVERN", 
	"QO080_Debug_PCOMPLETE", 
	"QO080_Debug_POUTRO"
}
ScriptActivation[ScriptCode.QO080].AbleToRun = nil



ScriptActivation[ScriptCode.QO110] = {}
ScriptActivation[ScriptCode.QO110].name = "QO110_DervishSlaves"
ScriptActivation[ScriptCode.QO110].display_name = "Dervish Slaves"
ScriptActivation[ScriptCode.QO110].start_chap = Chapters.Ruling_Part2
ScriptActivation[ScriptCode.QO110].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO110].states =
{
	-- DevFrontEnd: allow
	"INTRO",
	"ENTER_CAVE", 
	"ENTER_THE_PIT", 
	"EXIT_THE_CAVE",
	"RETURN_TO_HOBSON"
}
ScriptActivation[ScriptCode.QO110].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle",
	"Aurora\\DesertPleasureCave",
	"Aurora\\DesertPleasureCave",
	"Aurora\\TheDesert",
	"Albion\\BowerstoneCastle"
}
ScriptActivation[ScriptCode.QO110].initial_markers =
{
	-- DevFrontEnd: allow
	"QO110_Debug_PINTRO",
	"QO110_Debug_PENTER_CAVE", 
	"QO110_Debug_PENTER_PIT_ROOM",
	"QO110_Debug_PENTER_CAVE",
	"QO110_Debug_PRETURN_TO_QUEST_GIVER",
}
ScriptActivation[ScriptCode.QO110].AbleToRun = function()

	if Gameflow.Ruling.DervishSlavesActive or Gameflow.InitialQuest == ScriptCode.QO110 then
		return true
	else
		return false
	end

end

--QO060 Bowerstone Marriage
ScriptActivation[ScriptCode.QO060] = {}
ScriptActivation[ScriptCode.QO060].name = "QO060_BowerstoneMarriage"
ScriptActivation[ScriptCode.QO060].display_name = "Bowerstone Marriage"
ScriptActivation[ScriptCode.QO060].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QO060].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO060].states = 
{
	-- DevFrontEnd: allow
	"INTRO",
	"APPROACH_SPOUSE",
	"GIFTING",
	"DATE",
	"PROPOSAL",
	"RETURN_TO_HOUSE",
	"CHOICE",
	"KILL_NASTY",
	"KILL_NICE",
	"WALK_AWAY",
	"END"
}
ScriptActivation[ScriptCode.QO060].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage"
}

ScriptActivation[ScriptCode.QO060].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO060_Debug_PINTRO", 
	"QO060_Debug_PINTRO",
	"QO060_Debug_PINTRO", 
	"QO060_Debug_PDATE",
	"QO060_Debug_PDATE",
	"QO060_Debug_PDATE", 
	"QO060_Debug_PCHOICE", 
	"QO060_Debug_PCHOICE",
	"QO060_Debug_PCHOICE",
	"QO060_Debug_PCHOICE",
	"QO060_Debug_PINTRO"
}
ScriptActivation[ScriptCode.QO060].AbleToRun = nil



--Sam and Max Part 1
ScriptActivation[ScriptCode.QO085] = {}
ScriptActivation[ScriptCode.QO085].name = "QO085_SamAndMaxPartOne"
ScriptActivation[ScriptCode.QO085].display_name = "Sam and Max Part One"
ScriptActivation[ScriptCode.QO085].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QO085].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO085].states = 
{
	-- DevFrontEnd: allow
	"INTRO", 
	"DIG_UP_BOOK", 
	"FIGHT_HOLLOWMEN", 
	"RETURN_BOOK", 
	"END"
}
ScriptActivation[ScriptCode.QO085].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\Mangroves", 
	"Albion\\NewMillFields", 
	"Albion\\NewMillFields",
	"Albion\\Mangroves", 
	"Albion\\Mangroves"
}
ScriptActivation[ScriptCode.QO085].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO085_Debug_PINTRO", 
	"QO085_Debug_PDIG_UP_BOOK", 
	"QO085_Debug_PDIG_UP_BOOK", 
	"QO085_Debug_PINTRO", 
	"QO085_Debug_PINTRO"
}
ScriptActivation[ScriptCode.QO085].AbleToRun = function()

	if Gameflow.InitialQuest == ScriptCode.QO090 then
		return false
	else
		return true
	end
	
end

--Sam and Max Part Two
ScriptActivation[ScriptCode.QO090] = {}
ScriptActivation[ScriptCode.QO090].name = "QO090_SamAndMaxRedux"
ScriptActivation[ScriptCode.QO090].display_name = "Sam and Max Redux"
ScriptActivation[ScriptCode.QO090].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QO090].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO090].states = 
{
	-- DevFrontEnd: allow
	"INTRO", 
	"ACCEPTED",
	"WISP_GLANCE",
	"FIRST_SCARE",
	"HOLLOWMEN",
	"WISP_CHASE",
	"SKULL_TREE",
	"CRYPT_FIGHT",
	"SPIKES",
	"GENERATOR",
	"ABYSS",
	"STATUES",
	"FIND_MAX", 
	"SAM_ARRIVES",
	"FIGHT_BROTHERS",
	"SHIELD_DOWN",
	"BOOK_CUTSCENE",
	"OUTRO"
	
}
ScriptActivation[ScriptCode.QO090].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\Mangroves", 
	"Albion\\Mangroves", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown",
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown",
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown", 
	"Optional\\GhostTown",
	"Optional\\GhostTown", 
	"Optional\\GhostTown"
}
ScriptActivation[ScriptCode.QO090].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO090_Debug_PINTRO", 
	"QO090_Debug_PINTRO", 
	"QO090_Debug_PTOMB_START", 
	"QO090_Debug_PTOMB_START", 
	"QO090_Debug_PTOMB_START", 
	"QO090_Debug_PTHIN_BRIDGE", 
	"QO090_Debug_PWELL_OF_TOMBS", 
	"QO090_Debug_PWELL_OF_TOMBS", 
	"QO090_Debug_PSPIKES", 
	"QO090_Debug_PSPIKES", 
	"QO090_Debug_PSPIKES", 
	"QO090_Debug_PSPIKES", 
	"QO090_Debug_PFIND_MAX", 
	"QO090_Debug_PFIND_MAX", 
	"QO090_Debug_PFIND_MAX", 
	"QO090_Debug_PFIND_MAX", 
	"QO090_Debug_PFIND_MAX",
	"QO090_Debug_PFIND_MAX"
}
ScriptActivation[ScriptCode.QO090].AbleToRun = function()

	if Gameflow.InitialQuest == ScriptCode.QO090 or
		( QuestTracker.IsRegistered(QuestManager.HeroEntity, "QO085_SamAndMaxPartOne") and QuestTracker.IsCompleted(QuestManager.HeroEntity, "QO085_SamAndMaxPartOne") and (not Layers.IsLayerActive("QO085_SamAndMaxPartOne")) ) then -- SM: Added Layer check to prevent QO090 activating when loading a save game from the end of QO085.
			return true
	end
	
end


--QO120 Love Potion
ScriptActivation[ScriptCode.QO120] = {}
ScriptActivation[ScriptCode.QO120].name = "QO120_LovePotion"
ScriptActivation[ScriptCode.QO120].display_name = "Love Potion"
ScriptActivation[ScriptCode.QO120].start_chap = Chapters.Ruling_Part2
ScriptActivation[ScriptCode.QO120].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO120].states =
{
	-- DevFrontEnd: allow
	"INTRO",
	"ACCEPTED_QUEST", 
	"COLLECTION", 
	"END"
}
ScriptActivation[ScriptCode.QO120].initial_levels =
{
	-- DevFrontEnd: allow
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare",
	"Aurora\\BloodWeShare"
}
ScriptActivation[ScriptCode.QO120].initial_markers =
{
	-- DevFrontEnd: allow
	"QO120_Debug_PINTRO",
	"QO120_Debug_PACCEPTED_QUEST", 
	"QO120_Debug_PCOLLECTION", 
	"QO120_Debug_PEND"
}
ScriptActivation[ScriptCode.QO120].AbleToRun = function()
	if Gameflow.InitialQuest == ScriptCode.QO120 or
		(QuestTracker.IsRegistered(QuestManager.HeroEntity, "QO110_DervishSlaves") and QuestTracker.IsCompleted(QuestManager.HeroEntity, "QO110_DervishSlaves")) then
		return true
	end

end

--QO130 - Chesty Chess
ScriptActivation[ScriptCode.QO130] = {}
ScriptActivation[ScriptCode.QO130].name = "QO130_Chess"
ScriptActivation[ScriptCode.QO130].display_name = "Chesty's Chest of Chess"
ScriptActivation[ScriptCode.QO130].start_chap = Chapters.JourneyToBowerstoneIndustrial
ScriptActivation[ScriptCode.QO130].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO130].states =
{
	-- DevFrontEnd: allow
	"START",
	"FAKE_GAME",
	"BATTLE",
	"PLAY"
}
ScriptActivation[ScriptCode.QO130].initial_levels = 
{
	-- DevFrontEnd: allow
	"optional\\sunset house",
	"optional\\sunset house",
	"optional\\sunset house",
	"optional\\sunset house"
}
ScriptActivation[ScriptCode.QO130].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO130_Debug_PSETUP", 
	"QO130_Debug_PMAIN",
	"QO130_Debug_PMAIN", 
	"QO130_Debug_PMAIN",
}
ScriptActivation[ScriptCode.QO130].AbleToRun = nil

-- QO140 Balverine Forest
ScriptActivation[ScriptCode.QO140] = {}
ScriptActivation[ScriptCode.QO140].name = "QO140_BalverineForest"
ScriptActivation[ScriptCode.QO140].display_name = "Stolen Statue"
ScriptActivation[ScriptCode.QO140].start_chap = Chapters.Ruling_Part2
ScriptActivation[ScriptCode.QO140].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO140].states = 
{
	-- DevFrontEnd: allow
	"APPROACH_QUEST_GIVER", 
	"ACCEPTED_QUEST", 
	"ENTER_CURSEWOOD",
	"ENTER_VILLAGE", 
	"THROUGH_THE_FOREST",
	"ENCOUNTER_THIEF", 
	"CHOICE", 
	"GOOD_CHOICE", 
	"EVIL_CHOICE", 
	"RECEIVED_BALVERINE_STATUE", 
	"EPILOGUE"
}
ScriptActivation[ScriptCode.QO140].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\NewMillfields", 
	"Albion\\NewMillfields", 
	"Optional\\Cursewood", 
	"Optional\\Cursewood",
	"Optional\\Cursewood", 
	"Optional\\Cursewood", 
	"Optional\\Cursewood", 
	"Optional\\Cursewood", 
	"Optional\\Cursewood", 
	"Albion\\NewMillfields", 
	"Albion\\NewMillfields"
}
ScriptActivation[ScriptCode.QO140].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO140_Debug_PNEWMILLFIELDS", 
	"QO140_Debug_PNEWMILLFIELDS", 
	"QO140_Debug_PENTER_CURSEWOOD", 
	"QO140_Debug_PVILLAGE", 
	"QO140_Debug_PVILLAGE",
	"QO140_Debug_PCLEARING", 
	"QO140_Debug_PCLEARING", 
	"QO140_Debug_PCLEARING", 
	"QO140_Debug_PCLEARING", 
	"QO140_Debug_PCLEARING", 
	"QO140_Debug_PNEWMILLFIELDS", 
	"QO140_Debug_PNEWMILLFIELDS"
}
ScriptActivation[ScriptCode.QO140].AbleToRun = function()

	if Gameflow.Ruling.BeginBalverineQuest or Gameflow.InitialQuest == ScriptCode.QO140 then
		return true
	else
		return false
	end

end

-- QO160 Elise Elliot
ScriptActivation[ScriptCode.QO160] = {}
ScriptActivation[ScriptCode.QO160].name = "QO160_EliseElliot"
ScriptActivation[ScriptCode.QO160].display_name = "Elise Elliot"
ScriptActivation[ScriptCode.QO160].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QO160].end_chap = Chapters.ShadeLightDungeon
ScriptActivation[ScriptCode.QO160].states =
{
	-- DevFrontEnd: allow
	"APPROACH_QUEST_GIVER",
	"GO_TO_HIDEOUT", 
	"ENTER_CELLAR", 
	"INTERROGATE_FERRET", 
	"APPROACH_ELISE", 
	"ESCAPE_SEWER", 
	"BAT_ENCOUNTER", 
	"HOBBE_ENCOUNTER",
	"CONFESSION",
	"RETURN_TO_QUEST_GIVER", 
	"EPILOGUE"
}
ScriptActivation[ScriptCode.QO160].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneIndustrial",
	"Albion\\BowerstoneIndustrial",
	"Optional\\BWSIndustrialCave",
	"Optional\\BWSIndustrialCave",
	"Optional\\BWSIndustrialCave",
	"Optional\\BWSIndustrialCave",
	"Optional\\BWSIndustrialCave",
	"Optional\\BWSIndustrialCave",
	"Optional\\BWSIndustrialCave",
	"Optional\\BWSIndustrialCave",
	"Albion\\BowerstoneIndustrial",
}
ScriptActivation[ScriptCode.QO160].initial_markers =
{
	-- DevFrontEnd: allow
	"QO160_Debug_PAPPROACH_QUEST_GIVER",
	"QO160_Debug_PGO_TO_HIDEOUT", 
	"QO160_Debug_PENTER_CELLAR", 
	"QO160_Debug_PINTERROGATE_FERRET", 
	"QO160_Debug_PAPPROACH_ELISE", 
	"QO160_Debug_PESCAPE_SEWER", 
	"QO160_Debug_PBAT_ENCOUNTER", 
	"QO160_Debug_PHOBBE_ENCOUNTER", 
	"QO160_Debug_PCONFESSION", 
	"QO160_Debug_PRETURN_TO_QUEST_GIVER", 
	"QO160_Debug_PEPILOGUE"
}
ScriptActivation[ScriptCode.QO160].AbleToRun = nil

ScriptActivation[ScriptCode.QO170] = {}
ScriptActivation[ScriptCode.QO170].name = "QO170_SlaveTrade"
ScriptActivation[ScriptCode.QO170].display_name = "Slave Trade"
ScriptActivation[ScriptCode.QO170].start_chap = Chapters.Ruling_Part2
ScriptActivation[ScriptCode.QO170].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO170].states = 
{
	-- DevFrontEnd: allow
	"INTRO", 
	"QUEST_ACCEPTED", 
	"ARRIVED_AT_PUB", 
	"GO_TO_HIDEOUT", 
	"FIGHT_BIG", 
	"DONE"
}
ScriptActivation[ScriptCode.QO170].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\Sewers", 
	"Albion\\Sewers", 
	"Albion\\BWSMarket",
	"Albion\\BWSMarket", 
	"Optional\\Hideout",
	"Optional\\Hideout"
	
}
ScriptActivation[ScriptCode.QO170].initial_markers = 
{
	-- DevFrontEnd: allow
	"QO170_Debug_PINTRO", 
	"QO170_Debug_PQUEST_ACCEPTED", 
	"QO170_Debug_PARRIVED_AT_PUB", 
	"QO170_Debug_PGO_TO_DOCKS", 
	"QO170_Debug_PARRIVED_AT_DOCKS", 
	"QO170_Debug_PGO_TO_HIDEOUT", 
	"QO170_Debug_PFIGHT_BIG", 
	"QO170_Debug_PDONE"
}
ScriptActivation[ScriptCode.QO170].AbleToRun = function()

	if Gameflow.Ruling.BeginSlaveTradeQuest or Gameflow.InitialQuest == ScriptCode.QO170 then
		return true
	else
		return false
	end

end

-- // --  V I G N E T T E S  -- // --

ScriptActivation[ScriptCode.QV150] = {}
ScriptActivation[ScriptCode.QV150].name = "QV150_LCEGift"
ScriptActivation[ScriptCode.QV150].display_name = "LCE Gift"
ScriptActivation[ScriptCode.QV150].start_chap = Chapters.GypsiesAndRenegades_Part_2_RenownBreak
ScriptActivation[ScriptCode.QV150].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV150].states =
{
	-- DevFrontEnd: allow
	"GIVE_LCE_GIFT",
	"CHECK_FOR_REGION_VISITED", 
	"END"
}
ScriptActivation[ScriptCode.QV150].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\MistpeakValley",
	"Albion\\MistpeakValley",
	"Albion\\MistpeakValley"
}
ScriptActivation[ScriptCode.QV150].initial_markers =
{
	-- DevFrontEnd: allow
	"QV150_Debug_PCHECK_LCE",
	"QV150_Debug_PCHECK_FOR_REGION_VISITED", 
	"QV150_Debug_PEND"
}
ScriptActivation[ScriptCode.QV150].AbleToRun = nil		-- DJC for PC we want this quest to always be available

--QV010 Castle Library Puzzle

ScriptActivation[ScriptCode.QV010] = {}
ScriptActivation[ScriptCode.QV010].name = "QV010_CastleLibrary"
ScriptActivation[ScriptCode.QV010].display_name = "CastleLibrary"
ScriptActivation[ScriptCode.QV010].start_chap = Chapters.Coronation
ScriptActivation[ScriptCode.QV010].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV010].states = 
{
	-- DevFrontEnd: allow
	"READ_BOOKS",  
	"OPEN_DOOR"
}
ScriptActivation[ScriptCode.QV010].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle", 
	"Albion\\BowerstoneCastle", 
}
ScriptActivation[ScriptCode.QV010].initial_scenarios = 
{
	-- DevFrontEnd: allow
	"DefaultScenario",
	"DefaultScenario",
}
ScriptActivation[ScriptCode.QV010].initial_markers = 
{
	"QV010_Debug_PLIBRARY", 
	"QV010_Debug_PLIBRARY"
}
ScriptActivation[ScriptCode.QV010].AbleToRun = nil


--QV020 Chicken Racing

ScriptActivation[ScriptCode.QV020] = {}
ScriptActivation[ScriptCode.QV020].name = "QV020_ChickenRacing"
ScriptActivation[ScriptCode.QV020].display_name = "A Day At The (Chicken) Races"
ScriptActivation[ScriptCode.QV020].start_chap = Chapters.GypsiesAndRenegades_Part_2_RenownBreak
ScriptActivation[ScriptCode.QV020].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV020].states = 
{
	-- DevFrontEnd: allow
	"INTRO", 
	"MAIN"
}
ScriptActivation[ScriptCode.QV020].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QV020].initial_markers = 
{
	-- DevFrontEnd: allow
	"QV020_Debug_PMAIN",
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QV020].AbleToRun = function()

	if Gameflow.InitialQuest == ScriptCode.QV020 or
		( QuestTracker.IsRegistered(QuestManager.HeroEntity, "QO040_ChickenChaser") and QuestTracker.IsCompleted(QuestManager.HeroEntity, "QO040_ChickenChaser") and Gameflow.ChickenChaserCompleted ) then
			return true
	end
	
end

--Mourningwood House
ScriptActivation[ScriptCode.QV040] = {}
ScriptActivation[ScriptCode.QV040].name = "QV040_MourningwoodHouse"
ScriptActivation[ScriptCode.QV040].display_name = "Mourningwood House"
ScriptActivation[ScriptCode.QV040].start_chap = Chapters.JourneyToBowerstoneIndustrial
ScriptActivation[ScriptCode.QV040].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV040].states =
{
	-- DevFrontEnd: allow
	"UNSOLVED",
	"SOLVED"
}
ScriptActivation[ScriptCode.QV040].initial_levels =
{
	-- DevFrontEnd: allow
	"optional\\sunset house",
	"optional\\sunset house"
}
ScriptActivation[ScriptCode.QV040].initial_markers =
{
	-- DevFrontEnd: allow
	"QV040_Debug_PUNSOLVED",
	"QV040_Debug_PSOLVED"
}
ScriptActivation[ScriptCode.QV040].AbleToRun = function()

	if Gameflow.InitialQuest == ScriptCode.QO130 then
		return false
	else
		return true
	end
	
end

--Shooting range
ScriptActivation[ScriptCode.QV050] = {}
ScriptActivation[ScriptCode.QV050].name = "QV050_MourningwoodFortMortarRange"
ScriptActivation[ScriptCode.QV050].display_name = "Mourningwood Fort Mortar Range"
ScriptActivation[ScriptCode.QV050].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QV050].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV050].states = 
{
	-- DevFrontEnd: allow
	"START",
	"SHOOTING_RANGE",
	"OUTRO"
}
ScriptActivation[ScriptCode.QV050].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\Mangroves",
	"Albion\\Mangroves",
	"Albion\\Mangroves"
}
ScriptActivation[ScriptCode.QV050].AbleToRun = nil

--Retirement
ScriptActivation[ScriptCode.QV080] = {}
ScriptActivation[ScriptCode.QV080].name = "QV080_Retirement"
ScriptActivation[ScriptCode.QV080].display_name = "Retirement"
ScriptActivation[ScriptCode.QV080].start_chap = Chapters.Opening
ScriptActivation[ScriptCode.QV080].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV080].states =
{
	-- DevFrontEnd: allow
	"START",
	"END"
}
ScriptActivation[ScriptCode.QV080].initial_levels =
{
	-- DevFrontEnd: allow
	"DemonDoors\\MPV_DemonDoor",
	"DemonDoors\\MPV_DemonDoor"
}
ScriptActivation[ScriptCode.QV080].initial_markers =
{
	-- DevFrontEnd: allow
	"QV080_Debug_PSTART",
	"QV080_Debug_PEND"
}
ScriptActivation[ScriptCode.QV080].AbleToRun = nil

--Wolf's Bane
ScriptActivation[ScriptCode.QV090] = {}
ScriptActivation[ScriptCode.QV090].name = "QV090_WolfsBane"
ScriptActivation[ScriptCode.QV090].display_name = "Wolf's Bane"
ScriptActivation[ScriptCode.QV090].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QV090].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV090].states =
{
	-- DevFrontEnd: allow
	"GET_SKULL", 
	"WOLF_APPEARS",
	"OPEN_TOMB"
}
ScriptActivation[ScriptCode.QV090].initial_levels =
{
	-- DevFrontEnd: allow
	"Optional\\Cursewood",
	"Optional\\Cursewood",
	"Optional\\Cursewood"
}
ScriptActivation[ScriptCode.QV090].initial_markers =
{
	-- DevFrontEnd: allow
	"QV090_Debug_PGET_SKULL",
	"QV090_Debug_PGET_TORSO",
	"QV090_Debug_POPEN_TOMB"
}
ScriptActivation[ScriptCode.QV090].AbleToRun = nil

ScriptActivation[ScriptCode.QV100] = {}
ScriptActivation[ScriptCode.QV100].name = "QV100_DarkSanctum"
ScriptActivation[ScriptCode.QV100].display_name = "Leverage"
ScriptActivation[ScriptCode.QV100].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QV100].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV100].states =
{
	-- DevFrontEnd: allow
	"START",
	"FIRST_SACRAFICE",
	"REPEAT_SACRAFICE", 
	"END"
}
ScriptActivation[ScriptCode.QV100].initial_levels =
{
	-- DevFrontEnd: allow
	"Optional\SkormRuins",
	"Optional\SkormRuins",
	"Optional\SkormRuins",
	"Optional\SkormRuins",	
}
ScriptActivation[ScriptCode.QV100].initial_markers =
{
	-- DevFrontEnd: allow
	"QV100_Debug_PSTART",
	"QV100_Debug_PFIRST_SACRAFICE", 
	"QV100_Debug_PFIRST_SACRAFICE", 
	"QV100_Debug_PEND"
}
ScriptActivation[ScriptCode.QV100].AbleToRun = nil



ScriptActivation[ScriptCode.QV110] = {}
ScriptActivation[ScriptCode.QV110].name = "QV110_ResistanceHQSim"
ScriptActivation[ScriptCode.QV110].display_name = "Resistance HQ"
ScriptActivation[ScriptCode.QV110].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QV110].end_chap = Chapters.Coronation
ScriptActivation[ScriptCode.QV110].states =
{
	-- DevFrontEnd: allow
	"SETUP"
}
ScriptActivation[ScriptCode.QV110].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneIndustrial",
}
ScriptActivation[ScriptCode.QV110].initial_markers =
{
	-- DevFrontEnd: allow
	"QV110_Debug_PSETUP",
}
ScriptActivation[ScriptCode.QV110].AbleToRun = nil

-- EliseElliot Romance vignette
ScriptActivation[ScriptCode.QV130] = {}
ScriptActivation[ScriptCode.QV130].name = "QV130_EliseElliotRomance"
ScriptActivation[ScriptCode.QV130].display_name = "Elise Elliot Romance"
ScriptActivation[ScriptCode.QV130].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QV130].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV130].states =
{
	-- DevFrontEnd: allow
	"START"
}
ScriptActivation[ScriptCode.QV130].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneIndustrial"
}
ScriptActivation[ScriptCode.QV130].initial_markers =
{
	-- DevFrontEnd: allow
	"QV130_Debug_PSTART"
}
ScriptActivation[ScriptCode.QV130].AbleToRun = function()
	if Gameflow.InitialQuest == ScriptCode.QV130 
	or (( QuestTracker.IsRegistered(QuestManager.HeroEntity, "QO160_EliseElliot") and QuestTracker.IsCompleted(QuestManager.HeroEntity, "QO160_EliseElliot"))
		and Gameflow.QO160_PlayerWonBackElise) then
		return true
	end
end
-- // --  U T I L I T I E S  -- // --

ScriptActivation[ScriptCode.QU001] = {}
ScriptActivation[ScriptCode.QU001].name = "QU001_Achievements"
ScriptActivation[ScriptCode.QU001].display_name = "Achievements"
ScriptActivation[ScriptCode.QU001].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU001].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU001].states = {
"START", 
"SECOND", 
"THIRD"}
ScriptActivation[ScriptCode.QU001].AbleToRun = function()

	if ScriptFunction.IsDLC2Premium() then
		return true
	end
	
end


ScriptActivation[ScriptCode.QU010] = {}
ScriptActivation[ScriptCode.QU010].name = "QU010_Collectables"
ScriptActivation[ScriptCode.QU010].display_name = "Collectables"
ScriptActivation[ScriptCode.QU010].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU010].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU010].states = {
"START", 
"SECOND", 
"THIRD"}
ScriptActivation[ScriptCode.QU010].AbleToRun = nil

ScriptActivation[ScriptCode.QU030] = {}
ScriptActivation[ScriptCode.QU030].name = "QU030_CraneManager"
ScriptActivation[ScriptCode.QU030].display_name = "Crane Manager"
ScriptActivation[ScriptCode.QU030].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU030].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU030].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU030].AbleToRun = nil


--Locked door manager
ScriptActivation[ScriptCode.QU040] = {}
ScriptActivation[ScriptCode.QU040].name = "QU040_LockedDoorManager"
ScriptActivation[ScriptCode.QU040].display_name = "Locked Door Manager"
ScriptActivation[ScriptCode.QU040].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU040].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU040].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU040].AbleToRun = nil

--timed particle effect manager
ScriptActivation[ScriptCode.QU050] = {}
ScriptActivation[ScriptCode.QU050].name = "QU050_TimedParticleManager"
ScriptActivation[ScriptCode.QU050].display_name = "Timed Particles Manager"
ScriptActivation[ScriptCode.QU050].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU050].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU050].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU050].AbleToRun = nil

--Increase trail intensity while in mistpeak
ScriptActivation[ScriptCode.QU060] = {}
ScriptActivation[ScriptCode.QU060].name = "QU060_MistPeakBCTBrightness"
ScriptActivation[ScriptCode.QU060].display_name = "MistPeakBCTBrightness"
ScriptActivation[ScriptCode.QU060].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU060].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU060].states =
{
	"BRIGHTNESS_CHECK"

}
ScriptActivation[ScriptCode.QU060].initial_levels =
{
	"Albion\\MistpeakValley"
}
ScriptActivation[ScriptCode.QU060].initial_markers =
{
	"QU060_Debug_PBRIGHTNESS_CHECK"
}
ScriptActivation[ScriptCode.QU060].AbleToRun = nil

--Time Manager
ScriptActivation[ScriptCode.QU247] = {}
ScriptActivation[ScriptCode.QU247].name = "QU247_TimeManager"
ScriptActivation[ScriptCode.QU247].display_name = "Time Manager"
ScriptActivation[ScriptCode.QU247].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU247].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU247].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU247].AbleToRun = nil

--Calendar Manager
ScriptActivation[ScriptCode.QU365] = {}
ScriptActivation[ScriptCode.QU365].name = "QU365_CalendarManager"
ScriptActivation[ScriptCode.QU365].display_name = "Calendar Manager"
ScriptActivation[ScriptCode.QU365].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU365].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU365].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU365].AbleToRun = nil


--Marriage ICS stuff
ScriptActivation[ScriptCode.QU070] = {}
ScriptActivation[ScriptCode.QU070].name = "QU070_MarriageICS"
ScriptActivation[ScriptCode.QU070].display_name = "Marriage ICS Manager"
ScriptActivation[ScriptCode.QU070].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU070].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU070].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU070].initial_levels = 
{
	"Albion\\NewMillfields"
}
ScriptActivation[ScriptCode.QU070].AbleToRun = nil

ScriptActivation[ScriptCode.QU080] = {}
ScriptActivation[ScriptCode.QU080].name = "QU080_ChildBirthICS"
ScriptActivation[ScriptCode.QU080].display_name = "ChildBirthICS"
ScriptActivation[ScriptCode.QU080].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU080].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU070].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU080].AbleToRun = nil

--Desert heat haze manager
ScriptActivation[ScriptCode.QU100] = {}
ScriptActivation[ScriptCode.QU100].name = "QU100_AuroraHeatHazeManager"
ScriptActivation[ScriptCode.QU100].display_name = "Aurora Heat Haze Manager"
ScriptActivation[ScriptCode.QU100].start_chap = Chapters.AuroraPartOne
ScriptActivation[ScriptCode.QU100].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU100].states = 
{
	"START"
}
ScriptActivation[ScriptCode.QU100].initial_levels = 
{
	"Aurora\\TheDesert"
}
ScriptActivation[ScriptCode.QU100].initial_markers = 
{
	"QU100_Debug_PDESERT_UNLOCKED"
}
ScriptActivation[ScriptCode.QU100].AbleToRun = nil


--Banner Layers
ScriptActivation[ScriptCode.QU120] = {}
ScriptActivation[ScriptCode.QU120].name = "QU120_BannerLayers"
ScriptActivation[ScriptCode.QU120].display_name = "Banner Layers"
ScriptActivation[ScriptCode.QU120].start_chap = Chapters.Ruling_Part1
ScriptActivation[ScriptCode.QU120].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU120].states =
{
	"START",
	"CHECK_MORALITY", 
	"END"
}
ScriptActivation[ScriptCode.QU120].AbleToRun = nil 

-- Treasury gold manager
ScriptActivation[ScriptCode.QU130] = {}
ScriptActivation[ScriptCode.QU130].name = "QU130_TreasuryGoldManager"
ScriptActivation[ScriptCode.QU130].display_name = "Gold Manager"
ScriptActivation[ScriptCode.QU130].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU130].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU130].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU130].AbleToRun = nil

ScriptActivation[ScriptCode.QU140] = {}
ScriptActivation[ScriptCode.QU140].name = "QU140_DLC_OffersManager"
ScriptActivation[ScriptCode.QU140].display_name = "DLC Offers Manager"
ScriptActivation[ScriptCode.QU140].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU140].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU140].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU140].AbleToRun = nil

-- End game consequences script
ScriptActivation[ScriptCode.QU150] = {}
ScriptActivation[ScriptCode.QU150].name = "QU150_SandboxConsequences"
ScriptActivation[ScriptCode.QU150].display_name = "Consequences Manager"
ScriptActivation[ScriptCode.QU150].start_chap = Chapters.Ruling_Part2
ScriptActivation[ScriptCode.QU150].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU150].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU150].AbleToRun = nil

-- Judgement and End Game Opinions script
ScriptActivation[ScriptCode.QU160] = {}
ScriptActivation[ScriptCode.QU160].name = "QU160_JudgementOpinions"
ScriptActivation[ScriptCode.QU160].display_name = "Judgement Opinions Manager"
ScriptActivation[ScriptCode.QU160].start_chap = Chapters.Ruling_Part1
ScriptActivation[ScriptCode.QU160].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU160].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU160].AbleToRun = nil

ScriptActivation[ScriptCode.QU170] = {}
ScriptActivation[ScriptCode.QU170].name = "QU170_PrisonLightManager"
ScriptActivation[ScriptCode.QU170].display_name = "Prison Light Manager"
ScriptActivation[ScriptCode.QU170].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QU170].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU170].states =
{
	"START"
}
ScriptActivation[ScriptCode.QU170].AbleToRun = nil

-- // --  D E M O N   D O O R S  -- // --

--QD010 Bowerstone Castle Demon Door
ScriptActivation[ScriptCode.QD010] = {}
ScriptActivation[ScriptCode.QD010].name = "QD010_BowerstoneCastleDemonDoor"
ScriptActivation[ScriptCode.QD010].display_name = "Bowerstone Castle Demon Door"
ScriptActivation[ScriptCode.QD010].start_chap = Chapters.BrightwallHeroTest
ScriptActivation[ScriptCode.QD010].end_chap = Chapters.End
ScriptActivation[ScriptCode.QD010].states = 
{
	-- DevFrontEnd: allow
	"DOOR_INTRO",
	"WAIT_FOR_RULER", 
	"DOOR_OPENED"
}
ScriptActivation[ScriptCode.QD010].initial_levels = 
{
	-- DevFrontEnd: allow
	"optional\\sunset house", 
	"optional\\sunset house", 
	"optional\\sunset house", 
}
ScriptActivation[ScriptCode.QD010].initial_markers = 
{
	-- DevFrontEnd: allow
	"QD010_Debug_PDOOR_INTRO", 
	"QD010_Debug_PDOOR_INTRO",
	"QD010_Debug_PDOOR_INTRO"
}

ScriptActivation[ScriptCode.QD010].AbleToRun = nil

--QD020 Brightwall Demon Door
ScriptActivation[ScriptCode.QD020] = {}
ScriptActivation[ScriptCode.QD020].name = "QD020_BrightwallDemonDoor"
ScriptActivation[ScriptCode.QD020].display_name = "Brightwall Demon Door"
ScriptActivation[ScriptCode.QD020].start_chap = Chapters.BrightwallHeroTest
ScriptActivation[ScriptCode.QD020].end_chap = Chapters.End
ScriptActivation[ScriptCode.QD020].states = 
{
	-- DevFrontEnd: allow
	"DOOR_INTRO",
	"WAIT_AROUND",
	"OUTRO",
	"DOOR_OPENED"
}
ScriptActivation[ScriptCode.QD020].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage", 
	"Albion\\BrightwallVillage",
	"Albion\\BrightwallVillage"
}
ScriptActivation[ScriptCode.QD020].initial_markers = 
{
	-- DevFrontEnd: allow
	"QD020_Debug_PDOOR_INTRO", 
	"QD020_Debug_PDOOR_INTRO",
	"QD020_Debug_PDOOR_INTRO",
	"QD020_Debug_PDOOR_INTRO"
}
ScriptActivation[ScriptCode.QD020].AbleToRun = nil

-- Mistpeak Demon Door
ScriptActivation[ScriptCode.QD030] = {}
ScriptActivation[ScriptCode.QD030].name = "QD030_MistpeakValleyDemonDoor"
ScriptActivation[ScriptCode.QD030].display_name = "Mistpeak Valley Demon Door"
ScriptActivation[ScriptCode.QD030].start_chap = Chapters.BrightwallHeroTest
ScriptActivation[ScriptCode.QD030].end_chap = Chapters.End
ScriptActivation[ScriptCode.QD030].states = 
{
	-- DevFrontEnd: allow
	"DOOR_INTRO",
	"WAIT_FOR_EXPRESSION", 
	"DOOR_OPENED"
}
ScriptActivation[ScriptCode.QD030].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\MistpeakValley", 
	"Albion\\MistpeakValley", 
	"Albion\\MistpeakValley"
}
ScriptActivation[ScriptCode.QD030].initial_markers = 
{
	-- DevFrontEnd: allow
	"QD030_Debug_DemonDoorIntro", 
	"QD030_Debug_PWAIT_FOR_EXPRESSION",
	"QD030_Debug_PDOOR_OPENED"
}
ScriptActivation[ScriptCode.QD030].AbleToRun = nil

-- BloodWeShare Demon Door
ScriptActivation[ScriptCode.QD040] = {}
ScriptActivation[ScriptCode.QD040].name = "QD040_BloodWeShareDemonDoor"
ScriptActivation[ScriptCode.QD040].display_name = "Blood We Share Demon Door"
ScriptActivation[ScriptCode.QD040].start_chap = Chapters.Ruling_Part1
ScriptActivation[ScriptCode.QD040].end_chap = Chapters.End
ScriptActivation[ScriptCode.QD040].states = 
{
	-- DevFrontEnd: allow
	"INTRO",
	"WAIT_FOR_MAX_MORPH", 
	"DOOR_OPENED"
}
ScriptActivation[ScriptCode.QD040].initial_levels = 
{
	-- DevFrontEnd: allow
	"Aurora\\BloodWeShare", 
	"Aurora\\BloodWeShare", 
	"Aurora\\BloodWeShare"
}
ScriptActivation[ScriptCode.QD040].initial_markers = 
{
	-- DevFrontEnd: allow
	"QD040_Debug_PDOOR_INTRO", 
	"QD040_Debug_PDOOR_INTRO",
	"QD040_Debug_PDOOR_INTRO"
}
ScriptActivation[ScriptCode.QD040].AbleToRun = nil

--QD050 Mourningwood Demon Door

ScriptActivation[ScriptCode.QD050] = {}
ScriptActivation[ScriptCode.QD050].name = "QD050_MourningwoodDemonDoor"
ScriptActivation[ScriptCode.QD050].display_name = "Mouringwood Demon Door"
ScriptActivation[ScriptCode.QD050].start_chap = Chapters.BrightwallHeroTest
ScriptActivation[ScriptCode.QD050].end_chap = Chapters.End
ScriptActivation[ScriptCode.QD050].states = 
{
	-- DevFrontEnd: allow
	"DOOR_INTRO",
	"WAIT_FOR_FULLY_AUGMENTED", 
	"DOOR_OPENED"
}
ScriptActivation[ScriptCode.QD050].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\Mangroves", 
	"Albion\\Mangroves", 
	"Albion\\Mangroves"
}
ScriptActivation[ScriptCode.QD050].initial_markers = 
{
	-- DevFrontEnd: allow
	"QD050_Debug_PDOOR_INTRO", 
	"QD050_Debug_PDOOR_INTRO",
	"QD050_Debug_PDOOR_INTRO"
}
ScriptActivation[ScriptCode.QD050].AbleToRun = nil

--QD080 Millfields Demon Door

ScriptActivation[ScriptCode.QD080] = {}
ScriptActivation[ScriptCode.QD080].name = "QD080_MillfieldsDemonDoor"
ScriptActivation[ScriptCode.QD080].display_name = "Millfields Demon Door"
ScriptActivation[ScriptCode.QD080].start_chap = Chapters.BrightwallHeroTest
ScriptActivation[ScriptCode.QD080].end_chap = Chapters.End
ScriptActivation[ScriptCode.QD080].states = 
{
	-- DevFrontEnd: allow
	"DOOR_INTRO",
	"WAIT_FOR_UGLY", 
	"DOOR_OPENED"
}
ScriptActivation[ScriptCode.QD080].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\NewMillfields", 
	"Albion\\NewMillfields", 
	"Albion\\NewMillfields"
}
ScriptActivation[ScriptCode.QD080].initial_markers = 
{
	-- DevFrontEnd: allow
	"QD080_Debug_PDOOR_INTRO", 
	"QD080_Debug_PDOOR_INTRO",
	"QD080_Debug_PDOOR_INTRO"
}
ScriptActivation[ScriptCode.QD080].AbleToRun = nil

-- // --  P V P  -- // --

ScriptActivation[ScriptCode.QP000] = {}
ScriptActivation[ScriptCode.QP000].name = "QP000_PvP"
ScriptActivation[ScriptCode.QP000].display_name = "Ted's PvP Test"
ScriptActivation[ScriptCode.QP000].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QP000].end_chap = Chapters.End
ScriptActivation[ScriptCode.QP000].states =
{
	-- DevFrontEnd: allow
	"SETUP",
	"PLAY", 
	"END"
}
ScriptActivation[ScriptCode.QP000].initial_levels =
{
	-- DevFrontEnd: allow
	"PVP_GUI\\PVP_TeddyBox",
	"PVP_GUI\\PVP_TeddyBox",
	"PVP_GUI\\PVP_TeddyBox"
}
ScriptActivation[ScriptCode.QP000].initial_markers =
{
	-- DevFrontEnd: allow
	"QP000_Debug_PSETUP",
	"QP000_Debug_PPLAY", 
	"QP000_Debug_PEND"
}
ScriptActivation[ScriptCode.QP000].AbleToRun = nil

-- // -- T E S T   S C R I P T S -- // --

ScriptActivation[ScriptCode.QT001] = {}
ScriptActivation[ScriptCode.QT001].name = "QT001_RoadToCrucible"
ScriptActivation[ScriptCode.QT001].start_chap = Chapters.RoadToCrucible
ScriptActivation[ScriptCode.QT001].end_chap = Chapters.End
ScriptActivation[ScriptCode.QT001].states = 
{	
	-- DevFrontEnd: allow
	"START", 
	"MEET_HAMMER_IN_BRIGHTWOOD", 
	"HIGHWAYMEN_INTRO", 
	"BALVERINE_INTRO", 
	"PILLAR_ROOM", 
	"WESTCLIFF_CAMP_INTRO", 
	"OUTSIDE_CRUCIBLE", 
	"INSIDE_CRUCIBLE", 
	"FIRST_ROUND", 
	"SECOND_ROUND", 
	"COMPLETION_CUTSCENE"
}
ScriptActivation[ScriptCode.QT001].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\BowerstoneCastle", 
	"Albion\\DunecrestBay", 
	"Aurora\\BloodSands",
	"Albion\\DunecrestBay", 
	"Albion\\DunecrestBay", 
	"Albion\\DunecrestBay",
	"Albion\\DunecrestBay", 
	"Albion\\DunecrestBay", 
	"Albion\\DunecrestBay",
	"Albion\\DunecrestBay", 
	"Albion\\DunecrestBay"
}
ScriptActivation[ScriptCode.QT001].initial_markers = 
{
	-- DevFrontEnd: allow
	"QT001_Debug_PSTART", 
	"QT001_Debug_PMEET_HAMMER_IN_BRIGHTWOOD", 
	"QT001_Debug_PHIGHWAYMEN_INTRO",
	"QT001_Debug_PBALVERINE_INTRO", 
	"QT001_Debug_PPILLAR_ROOM", 
	"QT001_Debug_PWESTCLIFF_CAMP_INTRO",
	"QT001_Debug_POUTSIDE_CRUCIBLE", 
	"QT001_Debug_PINSIDE_CRUCIBLE", 
	"QT001_Debug_PFIRST_ROUND",
	"QT001_Debug_PSECOND_ROUND",
	"QT001_Debug_PCOMPLETION_CUTSCENE"
}
ScriptActivation[ScriptCode.QT001].AbleToRun = nil

ScriptActivation[ScriptCode.QT020] = {}
ScriptActivation[ScriptCode.QT020].name = "QT020_TestCullisGate"
ScriptActivation[ScriptCode.QT020].start_chap = Chapters.TestCullisGate
ScriptActivation[ScriptCode.QT020].end_chap = Chapters.End
ScriptActivation[ScriptCode.QT020].states = {"START", "UPDATE", "END"}
ScriptActivation[ScriptCode.QT020].initial_levels = {"HulshofTestLevel", "HulshofTestLevel", "HulshofTestLevel"}
ScriptActivation[ScriptCode.QT020].initial_markers = {"QT020_Debug_PSTART", "QT020_Debug_PUPDATE", "QT020_Debug_PEND"}
ScriptActivation[ScriptCode.QT020].AbleToRun = nil

ScriptActivation[ScriptCode.QT060] = {}
ScriptActivation[ScriptCode.QT060].name = "QT060_NewBeginning"
ScriptActivation[ScriptCode.QT060].display_name = "New Beginning"
ScriptActivation[ScriptCode.QT060].start_chap = Chapters.NewBeginning_start
ScriptActivation[ScriptCode.QT060].end_chap = Chapters.Thag
ScriptActivation[ScriptCode.QT060].states = {"START", "GATE", "ENTER_CAVE", "SHOT_SWITCH", "EXPRESSION_STATUE", "GUILD"}
ScriptActivation[ScriptCode.QT060].initial_levels = {"BowerLake", "BowerLake", "Caves\\BowerLake\\ThagsCave", "Caves\\BowerLake\\ThagsCave", "Caves\\BowerLake\\ThagsCave", "Caves\\BowerLake\\ThagsCave"}
ScriptActivation[ScriptCode.QT060].initial_markers = {"QT060_Debug_PStart", "QT060_Debug_PGate", "BLThagCaveStartFromBL_2", "QT060_Debug_PShotSwitch", "QT060_Debug_PExpressionStatue", "QT060_Debug_PGuild"}
ScriptActivation[ScriptCode.QT060].AbleToRun = nil

ScriptActivation[ScriptCode.QT065] = {}
ScriptActivation[ScriptCode.QT065].name = "QT065_Roadblock"
ScriptActivation[ScriptCode.QT065].display_name = "Roadblock"
ScriptActivation[ScriptCode.QT065].start_chap = Chapters.NewBeginning_start
ScriptActivation[ScriptCode.QT065].end_chap = Chapters.End
ScriptActivation[ScriptCode.QT065].AbleToRun = nil

ScriptActivation[ScriptCode.QT066] = {}
ScriptActivation[ScriptCode.QT066].name = "QT066_Gypsies"
ScriptActivation[ScriptCode.QT066].display_name = "Gypsies"
ScriptActivation[ScriptCode.QT066].start_chap = Chapters.Thag
ScriptActivation[ScriptCode.QT066].end_chap = Chapters.End
ScriptActivation[ScriptCode.QT066].AbleToRun = function()

	if not Gameflow.GypsiesNeeded then
		return false
	end
	
	return true
end

ScriptActivation[ScriptCode.QT070] = {}
ScriptActivation[ScriptCode.QT070].name = "QT070_Thag"
ScriptActivation[ScriptCode.QT070].display_name = "Thag"
ScriptActivation[ScriptCode.QT070].start_chap = Chapters.Thag
ScriptActivation[ScriptCode.QT070].end_chap = Chapters.End
ScriptActivation[ScriptCode.QT070].states = {"START"}
ScriptActivation[ScriptCode.QT070].initial_levels = {"BowerLake"}
ScriptActivation[ScriptCode.QT070].initial_markers = {"BLStartFromBLThagCave"}
ScriptActivation[ScriptCode.QT070].AbleToRun = nil

ScriptActivation[ScriptCode.QT000] = {}
ScriptActivation[ScriptCode.QT000].name = "QT000_Template"
ScriptActivation[ScriptCode.QT000].display_name = "Script Template"
ScriptActivation[ScriptCode.QT000].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QT000].end_chap = Chapters.End
ScriptActivation[ScriptCode.QT000].states = {"START", "MIDDLE", "FINALLE"}
ScriptActivation[ScriptCode.QT000].initial_levels = {"BowerLake", "Caves\\BowerLake\\ThagsCave", "Caves\\BowerLake\\ThagsCave"}
ScriptActivation[ScriptCode.QT000].initial_markers = {"QT000_Debug_PStart", "QT000_Debug_PMiddle", "QT000_Debug_PFinalle"}
ScriptActivation[ScriptCode.QT000].AbleToRun = nil

ScriptActivation[ScriptCode.QT999] = {}
ScriptActivation[ScriptCode.QT999].name = "QT999_TestCutscenes"
ScriptActivation[ScriptCode.QT999].display_name = "Test Cutscenes"
ScriptActivation[ScriptCode.QT999].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QT999].end_chap = Chapters.End
ScriptActivation[ScriptCode.QT999].states = {	"MIDDLE" }
ScriptActivation[ScriptCode.QT999].initial_levels = { "TestWorld\\GestureTagTestLevel" }
ScriptActivation[ScriptCode.QT999].AbleToRun = nil

--QMP010_Coliseum

ScriptActivation[ScriptCode.QMP010] = {}
ScriptActivation[ScriptCode.QMP010].name = "QMP010_Coliseum"
ScriptActivation[ScriptCode.QMP010].display_name = "PVP Coliseum"
ScriptActivation[ScriptCode.QMP010].start_chap = Chapters.PVP_Coliseum
ScriptActivation[ScriptCode.QMP010].end_chap = Chapters.PVP_ShootingRange
ScriptActivation[ScriptCode.QMP010].states = 
{
	-- DevFrontEnd: allow
	"START",
	"GAME_COUNTDOWN",
	"GAME_START",
	"RESULTS_SCREEN",
	"END_STATE"
}
ScriptActivation[ScriptCode.QMP010].initial_levels = 
{
	-- DevFrontEnd: allow
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
}
ScriptActivation[ScriptCode.QMP010].initial_markers = 
{
	-- DevFrontEnd: allow
	"QMP010_Debug_START",
	"QMP010_Debug_GAME_COUNTDOWN",
	"QMP010_Debug_GAME_START",
	"QMP010_Debug_RESULTS_SCREEN",
	"QMP010_Debug_END_STATE"
}
ScriptActivation[ScriptCode.QMP010].AbleToRun = nil

---Shooting Range

ScriptActivation[ScriptCode.QMP020] = {}
ScriptActivation[ScriptCode.QMP020].name = "QMP020_ShootingRange"
ScriptActivation[ScriptCode.QMP020].display_name = "PVP Shooting Range"
ScriptActivation[ScriptCode.QMP020].start_chap = Chapters.PVP_ShootingRange
ScriptActivation[ScriptCode.QMP020].end_chap = Chapters.PVP_MortarCommander
ScriptActivation[ScriptCode.QMP020].states =
{
	-- DevFrontEnd: allow
	"SETUP",
	"COUNTDOWN", 
	"START", 
	"GAME_OVER", 
	"END"
}
ScriptActivation[ScriptCode.QMP020].initial_levels =
{
	-- DevFrontEnd: allow
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp"
}
ScriptActivation[ScriptCode.QMP020].initial_markers =
{
	-- DevFrontEnd: allow
	"QMP020_Debug_PSETUP",
	"QMP020_Debug_PCOUNTDOWN", 
	"QMP020_Debug_PSTART", 
	"QMP020_Debug_PGAME_OVER", 
	"QMP020_Debug_PEND"
}
ScriptActivation[ScriptCode.QMP020].AbleToRun = nil

ScriptActivation[ScriptCode.QMP040] = {}
ScriptActivation[ScriptCode.QMP040].name = "QMP040_CompetitiveJobs"
ScriptActivation[ScriptCode.QMP040].display_name = "PVP Competitive Jobs"
ScriptActivation[ScriptCode.QMP040].start_chap = Chapters.PVP_CompetitiveJobs
ScriptActivation[ScriptCode.QMP040].end_chap = Chapters.PVP_End
ScriptActivation[ScriptCode.QMP040].states =
{
	-- DevFrontEnd: allow
	"START",
	"GAME_COUNTDOWN", 
	"GAME_START", 
	"RESULTS_SCREEN", 
	"END_STATE"
}
ScriptActivation[ScriptCode.QMP040].initial_levels =
{
	-- DevFrontEnd: allow
	"PVP_GUI\\PVPArena",
	"PVP_GUI\\PVPArena",
	"PVP_GUI\\PVPArena",
	"PVP_GUI\\PVPArena",
	"PVP_GUI\\PVPArena"
}
ScriptActivation[ScriptCode.QMP040].initial_markers =
{
	-- DevFrontEnd: allow
	"QMP040_Debug_PSTART",
	"QMP040_Debug_PGAME_COUNTDOWN", 
	"QMP040_Debug_PGAME_START", 
	"QMP040_Debug_PRESULTS_SCREEN", 
	"QMP040_Debug_PEND_STATE"
}
ScriptActivation[ScriptCode.QMP040].AbleToRun = nil

-- // DLC \\ --

--// DAY ONE \\ --

--// Renegade Shooting Range
ScriptActivation[ScriptCode.QV070] = {}
ScriptActivation[ScriptCode.QV070].name = "QV070_RenegadeShootingRangeDLC"
ScriptActivation[ScriptCode.QV070].display_name = "Renegade Shooting Range DLC"
ScriptActivation[ScriptCode.QV070].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QV070].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV070].states =
{
	"INTRO_VIGNETTE",
	"PLAY_SHOOTING_RANGE", 
	"COUNTDOWN", 
	"START", 
	"SCORE", 
	"PRIZE", 
	"RESTART"
}
ScriptActivation[ScriptCode.QV070].initial_levels =
{
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp",
	"Albion\\MistPeak_RenegadeCamp"
}
ScriptActivation[ScriptCode.QV070].initial_markers =
{
	"QV070_Debug_POFFER",
	"QV070_Debug_PSETUP", 
	"QV070_Debug_PCOUNTDOWN", 
	"QV070_Debug_PSTART", 
	"QV070_Debug_PSCORE", 
	"QV070_Debug_PPRIZE", 
	"QV070_Debug_PRESTART"
}
ScriptActivation[ScriptCode.QV070].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if PackageManager.IsPackagePremium("FableIII_DayOne_UnderstoneQuestPack") then
		return true
	end
end

-- Underground Toon
ScriptActivation[ScriptCode.QO100] = {}
ScriptActivation[ScriptCode.QO100].name = "QO100_UndergroundTown"
ScriptActivation[ScriptCode.QO100].display_name = "Underground Town (Day 1 DLC)"
ScriptActivation[ScriptCode.QO100].start_chap = Chapters.BowerstoneAndBalverines_Part_1_RenownBreak
ScriptActivation[ScriptCode.QO100].end_chap = Chapters.End
ScriptActivation[ScriptCode.QO100].states =
{
	"START",
	"ACCEPTED", 
	"ENTERED_UNDERSTONE", 
	"FIGHT_TO_TOWN", 
	"IN_TOWN", 
	"LIFT", 
	"END_FIGHT", 
	"OUTRO", 
	"CHOICE", 
	"FREE_TOWN", 
	"SLAVES", 
	"END"
}
ScriptActivation[ScriptCode.QO100].initial_levels = 
{
	"Albion\\BowerstoneIndustrial",
	"Albion\\BowerstoneIndustrial",
	"Optional\\UnderStone", 
	"Optional\\UnderStone",
	"Optional\\UnderStone", 
	"Optional\\UnderStone", 
	"Optional\\UnderStone",
	"Optional\\UnderStone", 
	"Optional\\UnderStone", 
	"Optional\\UnderStone",
	"Optional\\UnderStone", 
	"Optional\\UnderStone",
}
ScriptActivation[ScriptCode.QO100].initial_markers =
{
	"QO100_Debug_PSTART",
	"QO100_Debug_PACCEPTED", 
	"QO100_Debug_PENTERED_UNDERSTONE", 
	"QO100_Debug_PFIGHT_TO_TOWN", 
	"QO100_Debug_PIN_TOWN", 
	"QO100_Debug_PLIFT", 
	"QO100_Debug_PEND_FIGHT", 
	"QO100_Debug_POUTRO", 
	"QO100_Debug_POUTRO", 
	"QO100_Debug_POUTRO", 
	"QO100_Debug_POUTRO", 
	"QO100_Debug_POUTRO"
}
ScriptActivation[ScriptCode.QO100].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if PackageManager.IsPackagePremium("FableIII_DayOne_UnderstoneQuestPack") then
		return true
	end
end

--QV030_ReaverMansionOwnership
ScriptActivation[ScriptCode.QV030] = {}
ScriptActivation[ScriptCode.QV030].name = "QV030_ReaverMansionOwnership"
ScriptActivation[ScriptCode.QV030].display_name = "Reaver Mansion Ownership DLC"
ScriptActivation[ScriptCode.QV030].start_chap = Chapters.BowerstoneBoat
ScriptActivation[ScriptCode.QV030].end_chap = Chapters.End
ScriptActivation[ScriptCode.QV030].states = 
{
	"AWAIT_MANSION_PURCHASE",
	"AWAIT_WHEEL_INTERACTION",
	"ROUND_ONE_INTRO",
	"ROUND_ONE_FIGHT",
	"ROUND_ONE_OUTRO",
	"ROUND_TWO_INTRO",
	"ROUND_TWO_FIGHT",
	"ROUND_TWO_OUTRO",
	"ROUND_THREE_INTRO",
	"ROUND_THREE_FIGHT",
	"ROUND_THREE_OUTRO",
	"ROUND_FOUR_INTRO",
	"ROUND_FOUR_FIGHT",
	"ROUND_FOUR_OUTRO",
	"ROUND_FIVE_INTRO",
	"ROUND_FIVE_FIGHT",
	"ROUND_FIVE_OUTRO",
	"ROUND_SIX_INTRO",
	"ROUND_SIX_FIGHT",
	"ROUND_SIX_OUTRO",
	"SCRIPT_OUTRO",
	"SCRIPT_RESTART",
	"END_STATE"
}
ScriptActivation[ScriptCode.QV030].initial_levels = 
{
	"Albion\\NewMillfields",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars",
	"Albion\\HawneManorCellars"
}
ScriptActivation[ScriptCode.QV030].initial_markers = 
{
	"Travel_NMF_Manor",
	"QV030_Debug_AWAIT_WHEEL_INTERACTION",
	"QV030_Debug_ROUND_ONE_INTRO",
	"QV030_Debug_ROUND_ONE_FIGHT",
	"QV030_Debug_ROUND_ONE_OUTRO",
	"QV030_Debug_ROUND_ONE_INTRO",
	"QV030_Debug_ROUND_ONE_FIGHT",
	"QV030_Debug_ROUND_ONE_OUTRO",
	"QV030_Debug_ROUND_ONE_INTRO",
	"QV030_Debug_ROUND_ONE_FIGHT",
	"QV030_Debug_ROUND_ONE_OUTRO",
	"QV030_Debug_ROUND_ONE_INTRO",
	"QV030_Debug_ROUND_ONE_FIGHT",
	"QV030_Debug_ROUND_ONE_OUTRO",
	"QV030_Debug_ROUND_ONE_INTRO",
	"QV030_Debug_ROUND_ONE_FIGHT",
	"QV030_Debug_ROUND_ONE_OUTRO",
	"QV030_Debug_ROUND_ONE_INTRO",
	"QV030_Debug_ROUND_ONE_FIGHT",
	"QV030_Debug_ROUND_ONE_OUTRO",
	"QV030_Debug_END_STATE",
	"QV030_Debug_END_STATE",
	"QV030_Debug_END_STATE"
}
ScriptActivation[ScriptCode.QV030].AbleToRun = function()
		
	--// check to see if we're the premium package before unlocking
	if PackageManager.IsPackagePremium("FableIII_DayOne_UnderstoneQuestPack") then
		return true
	end
end

--===============================================
-- DLC EPISODE ONE
--===============================================

function ScriptFunction.IsDLC2Premium()
	
	-- this is for debug purposes.  The only reason this will get set is if you have it in your mystartup.lua
	if DLC2ScriptsDontCareAboutThePackage then
		return true
	end
	
	return PackageManager.IsPackagePremium("FableIII_DLC2_Paid")
	
end


--=========== QC190 Castle Assassin ==================
ScriptActivation[ScriptCode.QC190] = {}
ScriptActivation[ScriptCode.QC190].name = "QC190_CastleAssassin"
ScriptActivation[ScriptCode.QC190].display_name = "Castle Assassin"
ScriptActivation[ScriptCode.QC190].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC190].end_chap = Chapters.End
ScriptActivation[ScriptCode.QC190].states =
{
	"START",
	"ASSASSIN_ACS",
	"ASSASSIN_FIGHT",
	"ASSASSIN_DEFEATED_CLEANUP",
	"OLD_QUARTER_ACS",
	"END"
}
ScriptActivation[ScriptCode.QC190].initial_levels =
{
	"Albion\\BowerstoneCastle",
	"Albion\\CastleBattle",
	"Albion\\CastleBattle",
	"Albion\\CastleBattle",
	"Albion\\CastleBattle",
	"Albion\\CastleBattle"
}

ScriptActivation[ScriptCode.QC190].initial_scenarios = 
{
	"DefaultScenario",
	"Episode1Scenario",
	"Episode1Scenario",
	"Episode1Scenario",
	"Episode1Scenario",
	"Episode1Scenario"
}

ScriptActivation[ScriptCode.QC190].initial_markers = 
{
	"QC190_Debug_PSTART",
	"QC190_Debug_PTHRONEROOM",
	"QC190_Debug_PTHRONEROOM",
	"QC190_Debug_PTHRONEROOM",
	"QC190_Debug_PBEACH",
	"QC190_Debug_PBEACH"
}
ScriptActivation[ScriptCode.QC190].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	-- this package is available in both free and paid, just doesn't go past the gift giving if only the free version
	if ScriptFunction.IsDLC2Premium() or PackageManager.IsPackagePremium("FableIII_DLC2_Free") then
	
		-- DJC: We want this quest to run if we skip directly to it from the front end, or the game has been started outside
		-- of the range of this DLC, i.e. a natural playthough.
		-- We don't want this quest to run if skipping directly to a later quest in this DLC.
	
		if Gameflow.InitialQuest == ScriptCode.QC190
		or (Gameflow.InitialQuest < ScriptCode.QC190 or Gameflow.InitialQuest > ScriptCode.QC240)
		then
			if not Gameflow.DLC_EP1_CurrentChapter then
				DLC_EP1_ChapterProgress.SetAndUpdateChapter(DLC_EP1_Chapters.DLC2_Start)
			end
		end

		if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_Start, DLC_EP1_Chapters.DLC2_PrisonRiot) then
			return true
		end
	end
end

--============= QC200 Prison Riot =============
ScriptActivation[ScriptCode.QC200] = {}
ScriptActivation[ScriptCode.QC200].name = "QC200_PrisonRiot"
ScriptActivation[ScriptCode.QC200].display_name = "Prison Riot"
ScriptActivation[ScriptCode.QC200].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC200].end_chap = Chapters.End
ScriptActivation[ScriptCode.QC200].states =
{
	-- DevFrontEnd: allow
	"START",
	"APPROACH_BARRICADE",
	"BARRICADE", 
	"SEWERS", 
	"ASYLUM",
	"ASYLUM_MORGUE_INTRO", 	 
	"INFIRMARY", 	
	"CELLBLOCK_B", 
	"CELLBLOCK_B_FIRSTFLOOR",	
	"CELLBLOCK_A",
	"MAX_SECURITY_INTRO",	 
	"MAX_SECURITY_OUTRO", 
	"MEET_AT_DOCKS", 

}
ScriptActivation[ScriptCode.QC200].initial_levels =
{
	-- DevFrontEnd: allow
	"Episode1\\RavenscarPrison",	
	"Episode1\\RavenscarPrison",
	"Episode1\\RavenscarPrison",	
	"Episode1\\PrisonInterior",	
	"Episode1\\PrisonInterior",	
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",	
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\RavenscarPrison",		
}

ScriptActivation[ScriptCode.QC200].initial_markers =
{
	-- DevFrontEnd: allow
	"QC200_Debug_PSTART",
	"QC200_Debug_PSTART",		
	"QC200_Debug_PBARRICADE",
	"QC200_Debug_PSEWERS",
	"QC200_Debug_PASYLUM",
	"QC200_Debug_PASYLUM_MORGUE",
	"QC200_Debug_PINFIRMARY",
	"QC200_Debug_PCELLBLOCK_B",
	"QC200_Debug_PCELLBLOCK_B_UPSTAIRS",	
	"QC200_Debug_PCELLBLOCK_A",	
	"QC200_Debug_PMAX_SECURITY_INTRO",
	"QC200_Debug_PMAX_SECURITY_OUTRO",
	"QC200_Debug_PEND",		
}
ScriptActivation[ScriptCode.QC200].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if ScriptFunction.IsDLC2Premium() then
		if Gameflow.InitialQuest == ScriptCode.QC200 then
			DLC_EP1_ChapterProgress.SetAndUpdateChapter(DLC_EP1_Chapters.DLC2_PrisonRiot)
		end
		
		if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_PrisonRiot, DLC_EP1_Chapters.DLC2_Inventor) then
			return true
		end
	end
end

--============= QC210 Inventor's Island =============
ScriptActivation[ScriptCode.QC210] = {}
ScriptActivation[ScriptCode.QC210].name = "QC210_InventorsIsland"
ScriptActivation[ScriptCode.QC210].display_name = "The Inventor's Island"
ScriptActivation[ScriptCode.QC210].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC210].end_chap = Chapters.End
ScriptActivation[ScriptCode.QC210].states =
{
	-- DevFrontEnd: allow
	"INTRO",
	"APPROACH_COLIN",
	"ENTER_STREET", 
	"STREET_OF_THE_FUTURE", 
	"COLIN_INTRO", 
	"ROBOT_FIGHT", 
	"ENTER_CANAL",
	"BEETLE_INTRO",
	"FACTORY_VIGNETTES",
	"DOG_INTRO", 
	"FACTORY_ONE", 
	"FACTORY_TWO", 
	"CLOCKMAN_FACTORY", 
	"CLOCKMAN_INTRO",
	"CLOCKMAN_FIGHT",
	"CLOCKMAN_OUTRO",
	"RETURN_TO_PRISON", 
	"ALCHEMIST_INTRO", 
	"MEET_BEN", 
	"END", 
}
ScriptActivation[ScriptCode.QC210].initial_levels =
{
	-- DevFrontEnd: allow
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\Clockman",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\RavenscarPrison",
}

ScriptActivation[ScriptCode.QC210].initial_markers =
{
	-- DevFrontEnd: allow
	"QC210_Debug_PINTRO",
	"QC210_Debug_PAPPROACH_COLIN",
	"QC210_Debug_PAPPROACH_COLIN",
	"QC210_Debug_PAPPROACH_COLIN",
	"QC210_Debug_PCLOCKMAN_INTRO",
	"QC210_Debug_PCLOCKMAN_INTRO",
	"QC210_Debug_PCLOCKMAN_INTRO",
	"QC210_Debug_PCANAL",
	"QC210_Debug_PCANAL",
	"QC210_Debug_PFACTORY_ZONE",
	"QC210_Debug_PFACTORY_FIGHT_1",
	"QC210_Debug_PFACTORY_FIGHT_2",
	"QC210_Debug_PCLOCKMAN_FACTORY",
	"QC210_Debug_PCLOCKMAN_INTRO",
	"QC210_Debug_PCLOCKMAN_INTRO",
	"QC210_Debug_PCLOCKMAN_INTRO",
	"QC210_Debug_PCLOCKMAN_INTRO",
	"QC210_Debug_PSTART",
	"QC210_Debug_PSTART",
	"QC210_Debug_PSTART",
}
ScriptActivation[ScriptCode.QC210].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if ScriptFunction.IsDLC2Premium() then
		if Gameflow.InitialQuest == ScriptCode.QC210 then
			DLC_EP1_ChapterProgress.SetAndUpdateChapter(DLC_EP1_Chapters.DLC2_Inventor)
		end
		
		if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_Inventor, DLC_EP1_Chapters.DLC2_Alchemist) then
			return true
		end
	end
end

--============= QC220 Alchemist's Lab =============
ScriptActivation[ScriptCode.QC220] = {}
ScriptActivation[ScriptCode.QC220].name = "QC220_AlchemistLab"
ScriptActivation[ScriptCode.QC220].display_name = "The Alchemist's Lab"
ScriptActivation[ScriptCode.QC220].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC220].end_chap = Chapters.End
ScriptActivation[ScriptCode.QC220].states =
{
	-- DevFrontEnd: allow
	"INTRO",
	"BALVERINE_STATUES",
	"COURTYARD",
	"GRAVEYARD",
	"GENERATOR_DEFENCE",
	"APPROACH_HOUSE",
	"ENTER_HOUSE",
	"SINGING_FISH",
	"FIRE_HOLLOWMEN",
	"RAINBOW_HOBBES",
	"CREATURE_VAT_ROOM",
	"QC220_Alchemist_Intro_ACS",
	"PRISON"
}
ScriptActivation[ScriptCode.QC220].initial_levels =
{
	-- DevFrontEnd: allow
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\TheVestiges",
	"Episode1\\PrisonInterior"
}

ScriptActivation[ScriptCode.QC220].initial_markers =
{
	-- DevFrontEnd: allow
	"QC220_Debug_PINTRO",
	"QC220_Debug_PBALVERINE_STATUES",
	"QC220_Debug_PCOURTYARD",
	"QC220_Debug_PGRAVEYARD",
	"QC220_Debug_PGENERATOR_DEFENCE",
	"QC220_Debug_PAPPROACH_HOUSE",
	"QC220_Debug_PENTER_HOUSE",
	"QC220_Debug_PSINGING_FISH",
	"QC220_Debug_PFIRE_HOLLOWEN",
	"QC220_Debug_PRAINBOW_HOBBES",
	"QC220_Debug_PCREATURE_VAT_ROOM",
	"QC220_Debug_PFINAL_ROOM",
	"QC220_Debug_PPRISON"
	
}
ScriptActivation[ScriptCode.QC220].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if ScriptFunction.IsDLC2Premium() then
		if Gameflow.InitialQuest == ScriptCode.QC220 then
			DLC_EP1_ChapterProgress.SetAndUpdateChapter(DLC_EP1_Chapters.DLC2_Alchemist)
		end
		
		if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_Alchemist, DLC_EP1_Chapters.DLC2_Mastermind) then
			return true
		end
	end
end

--============= QC230 Mastermind's Trap =============
ScriptActivation[ScriptCode.QC230] = {}
ScriptActivation[ScriptCode.QC230].name = "QC230_MastermindsTrap"
ScriptActivation[ScriptCode.QC230].display_name = "The Mastermind's Trap"
ScriptActivation[ScriptCode.QC230].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC230].end_chap = Chapters.End
ScriptActivation[ScriptCode.QC230].states =
{
	-- DevFrontEnd: allow
	"HOBSON_KIDNAPPED",
	"SECRET_PASSAGE",
	"ASYLUM_FIGHTING",
	"HOBSON_REVEAL",
	"SOLDIER_BETRAYAL",
	"MIRROR_FIGHT",
	"END",
}
ScriptActivation[ScriptCode.QC230].initial_levels =
{
	-- DevFrontEnd: allow
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
	"Episode1\\PrisonInterior",
}

ScriptActivation[ScriptCode.QC230].initial_markers =
{
	-- DevFrontEnd: allow
	"QC230_Debug_PHOBSON_KIDNAPPED",
	"QC230_Debug_PSECRET_PASSAGE",
	"QC230_Debug_PASYLUM_FIGHTING",
	"QC230_Debug_PHOBSON_REVEAL",
	"QC230_Debug_PHOBSON_REVEAL",
	"QC230_Debug_PMIRROR_FIGHT",
	"QC230_Debug_PEND",
}
ScriptActivation[ScriptCode.QC230].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if ScriptFunction.IsDLC2Premium() then
		if Gameflow.InitialQuest == ScriptCode.QC230 then
			DLC_EP1_ChapterProgress.SetAndUpdateChapter(DLC_EP1_Chapters.DLC2_Mastermind)
		end
		
		if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_Mastermind, DLC_EP1_Chapters.DLC2_Sandbox) then
			return true
		end
	end
end

--============= QC240 Prison Sandbox =============
ScriptActivation[ScriptCode.QC240] = {}
ScriptActivation[ScriptCode.QC240].name = "QC999_Sandbox"
ScriptActivation[ScriptCode.QC240].display_name = "Prison Sandbox"
ScriptActivation[ScriptCode.QC240].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QC240].end_chap = Chapters.End
ScriptActivation[ScriptCode.QC240].states =
{
	-- DevFrontEnd: allow
	"START",
}
ScriptActivation[ScriptCode.QC240].initial_levels =
{
	-- DevFrontEnd: allow
	"Episode1\\PrisonInterior",
}

ScriptActivation[ScriptCode.QC240].initial_markers =
{
	-- DevFrontEnd: allow
	"QC240_Debug_PSTART",
}
ScriptActivation[ScriptCode.QC240].AbleToRun = function()
	if Gameflow.InitialQuest == ScriptCode.QC240 then
		DLC_EP1_ChapterProgress.SetAndUpdateChapter(DLC_EP1_Chapters.DLC2_Sandbox)
	end
		
	if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_Sandbox, DLC_EP1_Chapters.DLC2_End) then
		return true
	end
end

-- QD090 Prison Demon Door
ScriptActivation[ScriptCode.QD090] = {}
ScriptActivation[ScriptCode.QD090].name = "QD090_RavenscarKeepDemonDoor"
ScriptActivation[ScriptCode.QD090].display_name = "Ravenscar Keep Demon Door"
ScriptActivation[ScriptCode.QD090].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QD090].end_chap = Chapters.End
ScriptActivation[ScriptCode.QD090].states = 
{
	"DOOR_INTRO",
	"WAIT_FOR_WEARING_OUTFIT", 
	"DOOR_OPENED"
}
ScriptActivation[ScriptCode.QD090].initial_levels = 
{
	"Episode1\\RavenscarPrison", 
	"Episode1\\RavenscarPrison", 
	"Episode1\\RavenscarPrison"
}
ScriptActivation[ScriptCode.QD090].initial_markers = 
{
	"QD090_Debug_PDOOR_INTRO", 
	"QD090_Debug_PDOOR_INTRO",
	"QD090_Debug_PDOOR_INTRO"
}
ScriptActivation[ScriptCode.QD090].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if ScriptFunction.IsDLC2Premium() then

		if Gameflow.InitialQuest == ScriptCode.QD090 then
			DLC_EP1_ChapterProgress.SetAndUpdateChapter(DLC_EP1_Chapters.DLC2_Sandbox)
		end
		
		if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_Start, DLC_EP1_Chapters.DLC2_End) then
			return true
		end

	end
end


--============= QU666_PoisonBalverineEffect =============

ScriptActivation[ScriptCode.QU666] = {}
ScriptActivation[ScriptCode.QU666].name = "QU666_PoisonBalverineEffect"
ScriptActivation[ScriptCode.QU666].display_name = "Poison Balverine Thread"
ScriptActivation[ScriptCode.QU666].start_chap = Chapters.Sandbox
ScriptActivation[ScriptCode.QU666].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU666].states =
{
	"START",
}
ScriptActivation[ScriptCode.QU666].AbleToRun = function()
	--// check to see if we're the premium package before unlocking
	if ScriptFunction.IsDLC2Premium() then
		if DLC_EP1_ChapterProgress.IsDLCChapterBetween(DLC_EP1_Chapters.DLC2_Alchemist, DLC_EP1_Chapters.DLC2_End) then
			return true
		end
	end
end

-- QU667 RoboDog Sound Manager
ScriptActivation[ScriptCode.QU667] = {}
ScriptActivation[ScriptCode.QU667].name = "QU667_RoboDogSoundManager"
ScriptActivation[ScriptCode.QU667].display_name = "RoboDog Sound Manager"
ScriptActivation[ScriptCode.QU667].start_chap = Chapters.Start
ScriptActivation[ScriptCode.QU667].end_chap = Chapters.End
ScriptActivation[ScriptCode.QU667].states = 
{
	"START"
}
ScriptActivation[ScriptCode.QU667].AbleToRun = nil
